<?php

namespace Linkinfo;

use EDGVI10\DBWalker;
use EDGVI10\Helpers;

class Functions
{
    public static function encrypt($password)
    {
        $password = trim($password);
        $encrypted_password = null;
        for ($i = 0; $i < strlen($password); $i++) :
            $ascii = ord($password[$i]);
            $ascii_jumped = chr(intval($ascii) ^ (($i + 1) * 2));

            if ($ascii_jumped != "'") :
                $encrypted_password = $encrypted_password . $ascii_jumped;
            endif;
        endfor;

        return $encrypted_password;
    }

    public static function token($token)
    {
        $token = trim(str_replace("Bearer ", "", $token));

        $data["token"] = $token;

        $token = explode("-", Helpers::base64url_decode($token));
        $company_uuid = "{$token[0]}-{$token[1]}-{$token[2]}-{$token[3]}-{$token[4]}";
        $user_uuid = "{$token[7]}-{$token[8]}-{$token[9]}-{$token[10]}-{$token[11]}";

        $data["company_uuid"] = $company_uuid;
        $data["user_uuid"] = $user_uuid;

        return (object) $data;
    }

    public static function sendFCM($message, $fcm_token = null)
    {
        if (empty($fcm_token)) global $fcm_token;
        $return["success"] = false;

        $message = (object) $message;

        $data["to"] = $message->to;
        $data["data"]["notification"]["title"] = $message->title;
        $data["data"]["notification"]["body"] = $message->message;

        $request_options = [
            "method" => "POST",
            "endpoint" => "https://fcm.googleapis.com/fcm/send",
            "headers" => ["Authorization: key={$fcm_token}"],
            "data" => $data
        ];

        // $return["options"] = $request_options;

        $request = (object) Helpers::call($request_options);
        $response = (object) $request->response;

        if ($response->success == 0) :
            $return["message"] = "Não foi possível enviar a mensagem";
        else :
            $return["success"] = true;
            $return["message_id"] = $response->results[0]["message_id"];
        endif;

        return $return;
    }

    public static function getUserCode($access_token)
    {
        $token = Helpers::base64url_decode($access_token);
        $chunks = explode("-", $token);
        $uuid = "{$chunks[0]}-{$chunks[1]}-{$chunks[2]}-{$chunks[3]}-{$chunks[4]}";
        return $uuid;
    }

    public static function getUser($db, $params)
    {
        $select_users = [];
        $select_users["table"] = "`baselink`.`operadores`";
        $select_users["columns"] = [
            "'' AS `uuid`",
            "`operadores`.`CODIGO` AS `code`",
            "`lojas`.`COD_LOCAL` AS `store_code`",
            "`lojas`.`NOME` AS `store_name`",
            "`operadores`.`NOME_OPERADOR` AS `name`",
            "`operadores`.`DESCONTO` AS `max_discount`",
            "`operadores`.`ATIVO` AS `active`",
        ];

        $select_users["joins"][] = ["LEFT", "`baselink`.`lojas`", "`lojas`.`COD_LOCAL` = `operadores`.`COD_LOJA`"];

        if (isset($params["where"])) $select_users["where"] = $params["where"];

        $select_users = (object) $db->select($select_users, true);
        // return $select_users;

        foreach ($select_users->data as $row) :
            $user = (object) [];

            $user->uuid = md5($row->code);
            $user->code = $row->code;
            $user->name = $row->name;

            $user->store_code = $row->store_code;
            $user->store_name = $row->store_name;

            $user->max_discount = (float) $row->max_discount;

            // $user->active = (bool) $row->active;
            // $user->created_at = null;
            // $user->updated_at = null;
            // $user->deleted_at = null;

            $users[] = $user;
        endforeach;

        return $users;
    }

    public static function getPriceTables($db, $params = null)
    {
        $select_price_tables = [];
        $select_price_tables["table"] = "`baselink`.`tab_tabelas` AS `table`";
        $select_price_tables["columns"] = [
            "`table`.`CODIGO` AS `code`",
            "`table`.`VINCULO` AS `link`",
            "`table`.`DESCRICAO` AS `name`",
            "`table`.`PERCENTUAL` AS `percent`",

            "`table`.`USAVALOR` AS `use_value`",

            "`table`.`DESCONTO` AS `discount`",
            "`table`.`DSCUSTO` AS `coust_discount`",

            "`table`.`ACRESCIMO` AS `addition`",
            "`table`.`ACCUSTO` AS `coust_addition`",
            "`table`.`ACUSTOM` AS `coust_m_addition`",
        ];

        $select_price_tables = (object) $db->select($select_price_tables);

        $price_tables = [];
        foreach ($select_price_tables->data as $price_table) :
            $price_table->code = $price_table->code;
            $price_table->use_value = (bool) $price_table->use_value;

            $price_table->percent = str_replace(",", ".", $price_table->percent);
            $price_table->percent = (float) $price_table->percent;

            $price_table->discount = (bool) $price_table->discount;
            $price_table->coust_discount = (bool) $price_table->coust_discount;
            $price_table->addition = (bool) $price_table->addition;
            $price_table->coust_addition = (bool) $price_table->coust_addition;
            $price_table->coust_m_addition = (bool) $price_table->coust_m_addition;

            $price_table->name = $price_table->name;
            if ($price_table->percent > 0) :
                if ($price_table->addition) $price_table->name .= " (+{$price_table->percent}%)";
                if ($price_table->discount) $price_table->name .= " (-{$price_table->percent}%)";
            endif;
            if ($price_table->use_value) $price_table->name = "{$price_table->name} (valor fixo)";

            // TABELA DE PREÇOS ==========================================================================================================
            if ((bool) $price_table->use_value) :
                $price_table_products = [];
                $price_table_products["table"] = "`baselink`.`tab_produtos_tabelas` AS `price_table`";
                $price_table_products["columns"] = [
                    "`price_table`.`CODIGOBARRAS` AS `barcode`",
                    "`price_table`.`VALOR` AS `unit_price`",
                    "`price_table`.`UNIDADE` AS `unit_name`",
                ];
                $price_table_products["where"]["param_`price_table`.`CODIGO`"] = $price_table->code;
                $price_table_products["where"]["upper_`price_table`.`VALOR`"] = 0;

                $price_table_products = (object) $db->select($price_table_products);

                $table_items = [];
                foreach ($price_table_products->data as $row_price_table_item) :
                    $table_item = (object) [];
                    $table_item->barcode = $row_price_table_item->barcode;
                    $table_item->unit_price = (float) $row_price_table_item->unit_price;
                    $table_item->unit_name = $row_price_table_item->unit_name;

                    $table_items[] = $table_item;
                endforeach;

                // $price_table->table_items = $price_table_products;
                $price_table->table_items = $table_items;
            endif;

            $price_tables[] = $price_table;
        endforeach;

        return $price_tables;
    }

    public static function getDepartments($db, $params = null)
    {
        $select_departments = [];
        $select_departments["table"] = "`baselink`.`tab_departamento` AS `dpt`";
        $select_departments["columns"] = [
            "dpt.CODIGO",
            "dpt.DESCRICAO",
        ];
        // $select_departments["where"]["param_`dpt`.``"] = $_GET[""];

        $select_departments["order_by"] = ["orderasc_`dpt`.`DESCRICAO`"];
        $select_departments = (object) $db->select($select_departments);

        $departments = [];
        foreach ($select_departments->data as $row) :
            $department = (object) [];
            $department->code = $row->CODIGO;
            $department->name = trim($row->DESCRICAO);

            $departments[] = $department;
        endforeach;

        $return["departments"] = $departments;

        return $departments;
    }

    public static function getCategories($db, $params = null)
    {
        $select_categories = [];
        $select_categories["table"] = "`baselink`.`tab_categoria` AS `cat`";
        $select_categories["columns"] = [
            "cat.CODIGO_CATEG",
            "cat.DESCRICAO_CATEG",
        ];

        $select_categories["order_by"] = ["orderasc_`cat`.`DESCRICAO_CATEG`"];
        $select_categories = (object) $db->select($select_categories, true);

        $categories = [];
        foreach ($select_categories->data as $row) :
            $category = (object) [];
            $category->code = $row->CODIGO_CATEG;
            $category->name = trim($row->DESCRICAO_CATEG);

            $categories[] = $category;
        endforeach;

        $return["categories"] = $categories;

        return $categories;
    }

    public static function getPaymentMethods($db, $params = null)
    {
        $select_fechamentos = [];
        $select_fechamentos["table"] = "`baselink`.`tab_fechamentos` AS `payment`";
        $select_fechamentos["columns"] = [
            "payment.CODIGO",
            "payment.FECHAMENTO",
        ];

        $select_fechamentos["order_by"] = ["orderasc_`payment`.`FECHAMENTO`"];
        $select_fechamentos = (object) $db->select($select_fechamentos, true);

        $payments = [];
        foreach ($select_fechamentos->data as $row) :
            $payment = (object) [];
            $payment->code = $row->CODIGO;
            $payment->name = trim($row->FECHAMENTO);

            $payments[] = $payment;
        endforeach;

        $return["payments"] = $payments;

        return $payments;
    }

    public static function getCustomers($db, $params = null)
    {
        $select_customers = [];
        $select_customers["table"] = "`orc_link`.`clientes`";
        $select_customers["columns"] = [
            "`clientes`.`CODIGO_CLIENTE` AS `code`",
            "`clientes`.`FATEMPRESA` AS `company_receipt_code`",

            "`seller`.`COD_LOJA` AS `store_code`",
            "`clientes`.`CODIGO_VENDEDOR` AS `seller_code`",

            "`clientes`.`NOME` AS `name`",
            "`clientes`.`FANTASIA` AS `fancyname`",
            "`clientes`.`CPF_CGC` AS `document`",

            "`clientes`.`REVENDA` AS `resale`",

            "'' AS `phones`",
            "'' AS `emails`",

            "`clientes`.`TEL1` AS `phone1`",
            "`clientes`.`TEL2` AS `phone2`",
            "`clientes`.`TEL3` AS `phone3`",

            "`clientes`.`EMAIL` AS `email`",

            "'' AS `address`",
            "'' AS `address_latlng`",

            "`clientes`.`CEP` AS `address_zipcode`",
            "`clientes`.`ENDERECO` AS `address_name`",
            "`clientes`.`NUMERO` AS `address_number`",
            "`clientes`.`COMPLEMENTO` AS `address_info`",
            "`clientes`.`BAIRRO` AS `address_neighborhood`",
            "`clientes`.`CIDADE` AS `address_city`",
            "`clientes`.`ESTADO` AS `address_state`",

            "`clientes`.`LATITUDE` AS `address_lat`",
            "`clientes`.`LONGITUDE` AS `address_lng`",

            "`clientes`.`TIPOPAGAMENTO` AS `payment_table`",
            "`clientes`.`TABELA` AS `price_table`",
            // "`clientes`.`USA_OUTROS_PRODS_VENDA` AS `use_products_table`",
            "`clientes`.`USA_OUTROS_PRODS_VENDA` AS `use_products_table`",

            "`clientes`.`LC` AS `limit_available`",
            "`clientes`.`LD` AS `limit_credit`",

            "`clientes`.`CINATIVO` AS `active`",
            "`clientes`.`DATA_CAD` AS `created_at`",
        ];
        $select_customers["joins"][] = ["RIGHT", "`baselink`.`operadores` AS `seller`", "`seller`.`CODIGO` = `clientes`.`CODIGO_VENDEDOR` "];
        $select_customers["group_by"] = "`clientes`.`CODIGO_CLIENTE`";

        if (isset($params["where"])) $select_customers["where"] = $params["where"];
        // if (isset($_GET["customer_id"])) $select_customers["where"]["param_`clientes`.`CODIGO_CLIENTE`"] = $_GET["customer_id"];

        // $select_customers["limit"] = 10;
        $select_customers["order_by"] = ["orderasc_`clientes`.`NOME`", "orderasc_`clientes`.`FANTASIA`"];

        $select_customers = (object) $db->select($select_customers, true);
        // return $select_customers;

        $customers = [];
        foreach ($select_customers->data as $row) :
            $customer = (object) [];

            ############### Trata código
            $customer->code = $row->code;
            $customer->company_receipt_code = strlen($row->company_receipt_code) >= 3 ? $row->company_receipt_code : false;
            $customer->seller_code = $row->seller_code;

            ############### Trata NOME
            $customer->name = trim($row->name);
            $customer->fancyname = !empty($row->fancyname) ? trim($row->fancyname) : null;
            $customer->document = !empty($row->document) ? trim($row->document) : null;

            $customer->created_at = Helpers::dateTranslate($row->created_at);

            ############### Trata Contato
            $customer->emails = explode(";", $row->email);
            $phones = [];
            if (!empty($row->phone1)) $phones[] = Helpers::extractInt($row->phone1);
            if (!empty($row->phone2)) $phones[] = Helpers::extractInt($row->phone2);
            if (!empty($row->phone3)) $phones[] = Helpers::extractInt($row->phone3);
            $customer->phones = $phones;

            ############### Trata endereço
            $customer_address = [];
            $customer_address[] = "$row->address_name";
            if ($row->address_number != "") :
                $customer_address[] = ", {$row->address_number}";
            endif;
            if ($row->address_neighborhood != "") :
                $customer_address[] = " - {$row->address_neighborhood}";
            endif;
            if ($row->address_city != "") :
                $customer_address[] = ", {$row->address_city}";
                $customer_address[] = " ({$row->address_state})";
            endif;
            $customer->address = implode("", $customer_address);
            $customer->address_uf = $row->address_state;
            $customer->address_latlng = strlen($row->address_lat) ? implode(",", [$row->address_lat, $row->address_lng]) : null;

            ############## Revenda
            $customer->is_resale = (bool) $row->resale;

            ############## Trata tabela de preços
            $customer->use_price_table = strlen($row->price_table) ? $row->price_table : false;

            ############## Trata métodos de pagamento
            $customer->use_payment_table = (bool) $row->payment_table;
            if ($customer->use_payment_table) :
                $select_payments_table = [];
                $select_payments_table["table"] = "`baselink`.`tab_fechamentos_cliente` AS `payment`";
                $select_payments_table["where"]["param_`payment`.`CLIENTE`"] = $customer->code;

                $select_payments_table = (object) $db->select($select_payments_table);

                $payments_table = [];
                foreach ($select_payments_table->data as $row_payment) :
                    $payment = (object) [];
                    $payment->code = $row_payment->CODIGO;
                    $payment->name = $row_payment->FECHAMENTO;
                    // $payment->due = $row_payment->PRAZO;

                    $payments_table[] = $payment;
                endforeach;
                $customer->payments_table = $payments_table;
            endif;

            ############## Trata tabela de produtos
            $customer->use_products_table = (bool) $row->use_products_table;

            if ($row->use_products_table) :
                // SELECIONA TABELA DE PRODUTOS DO CLIENTE ==========================================================================================================
                $select_products_table = [];
                $select_products_table["table"] = "`baselink`.`tab_produtoscliente` AS `price_table`";
                $select_products_table["columns"] = [
                    "`product`.`CODIGO_BARRAS` AS `barcode`",
                    "`price_table`.`DESCRICAO` AS `name`",
                    "`price_table`.`VALOR` AS `unit_price`",
                    "`price_table`.`CODUNIDADE` AS `unit_code`",

                    "`product`.`DESCRICAO` AS `original_name`",
                    "`product`.`VALOR_VENDA` AS `original_unit_price`",
                    "`product`.`UNIDADE` AS `original_unit_code`",
                    // "`product`.`CODIGO_UNIDADE` AS `original_unit_cod`",
                ];
                $select_products_table["joins"][] = ["LEFT", "`baselink`.`produtos` AS `product`", "`product`.`CODIGO_BARRAS` = `price_table`.`CODIGO`"];

                $select_products_table["where"]["param_`price_table`.`CLIENTE`"] = $customer->code;

                $select_products_table["group_by"] = "`product`.`CODIGO_BARRAS`";
                $select_products_table["order_by"] = ["orderasc_`product`.`DESCRICAO`"];

                $select_products_table = (object) $db->select($select_products_table, true);

                $customer_products = [];
                foreach ($select_products_table->data as $product) :
                    $product->name = trim($product->name);
                    $product->unit_price = (float) $product->unit_price;
                    $product->original_unit_price = (float) $product->original_unit_price;

                    $customer_products[] = $product;
                endforeach;

                $customer->products = $customer_products;
            // $customer->products = $select_products_table;
            endif;

            $customer->limit_available = (float) $row->limit_available;
            $customer->limit_credit = (float) $row->limit_credit;

            $customers[] = $customer;
        endforeach;

        return $customers;
    }

    public static function getProducts($db, $params = null)
    {
        $select_products = [];
        $select_products["table"] = "`baselink`.`produtos` AS `product`";
        $select_products["columns"] = [
            "`product`.`CODIGO_LOJA` AS `store_code`",

            "`product`.`CODIGO_BARRAS` AS `barcode`",
            "`product`.`REFERENCIA` AS `ref`",
            "`product`.`DESCRICAO` AS `name`",

            "`brand`.`CODIGO` AS `brand_code`",
            "`brand`.`DESCRICAO` AS `brand_name`",

            "`departments`.`CODIGO` AS `department_code`",
            "`departments`.`DESCRICAO` AS `department_name`",
            "`categories`.`CODIGO_CATEG` AS `category_code`",
            "`categories`.`DESCRICAO_CATEG` AS `category_name`",

            "product.NOME_COR AS `color_name`",
            "product.TAMANHO AS `size_name`",

            "product.FLAG_DESC AS `discount`",
            "product.DESC_MAX AS `discount_max`",

            "`product`.`NEGATIVO` AS `available_block`",
            "`product`.`POSICAO_ESTOQ_ITEM` AS `available`",

            "`product`.`CUSTO_BASE_UNIT` AS `base_cost`",
            "`product`.`CUSTO_MED` AS `med_cost`",

            "`product`.`VALOR_VENDA` AS `unit_price`",

            "`product`.`PROMOCAO` AS `promotion`",
            "`product`.`USAVALOR` AS `promotion_use_value`",
            "`product`.`VALOR_PROM` AS `promotion_price`",
            "`product`.`FIXADATA` AS `promotion_use_date`",
            "`product`.`DATAINI_PROM` AS `promotion_date_start`",
            "`product`.`DATAFIM_PROM` AS `promotion_date_end`",

            "`product`.`COMPRIMENTO` AS `dim_length`",
            "`product`.`ALTURA` AS `dim_height`",
            "`product`.`LARGURA` AS `dim_width`",
            "`product`.`PESO_LIQUIDO` AS `weight`",
            "`product`.`PESO_BRUTO` AS `weight_real`",

            "`product`.`UNIDADE` AS `unit_code`",
            "`unit`.`UNIDADE` AS `unit_name`",

            "`product`.`COD_TRIB` AS `tributation_code`",
            "`product`.`CODNCM` AS `ncm_number`",

            "`product`.`INATIVO` AS `active`",
        ];
        $select_products["joins"][] = ["LEFT", "`baselink`.`tab_unidade` AS `unit`", "`unit`.`CODIGO` = `product`.`UNIDADE`"];
        $select_products["joins"][] = ["LEFT", "`baselink`.`tab_marcas` AS `brand`", "`brand`.`CODIGO` = `product`.`CODIGO_MARCA`"];
        $select_products["joins"][] = ["LEFT", "`baselink`.`tab_departamento` AS `departments`", "`departments`.`CODIGO` = `product`.`COD_DEPA`"];
        $select_products["joins"][] = ["LEFT", "`baselink`.`tab_categoria` AS `categories`", "`categories`.`CODIGO_CATEG` = `product`.`CODIGO_CATEGORIA`"];

        if (isset($params["where"])) $select_products["where"] = $params["where"];
        $select_products["where"]["param_`product`.`PRODUTO`"] = 1;
        $select_products["where"]["param_`product`.`INATIVO`"] = 0;
        // $select_products["where"]["param_`product`.`FV`"] = 1;

        $select_products["order_by"] = ["orderasc_`product`.`DESCRICAO`"];
        $select_products = (object) $db->select($select_products, true);

        // return $select_products; //->data;

        $products = [];
        foreach ($select_products->data as $row) :
            $product = (object) [];
            $product->barcode = $row->barcode;
            $product->ref = trim($row->ref);
            $product->name = trim($row->name);

            $product->brand_code = $row->brand_code;
            $product->brand_name = $row->brand_name;

            $product->department_code = $row->department_code;
            $product->department_name = $row->department_name;

            $product->category_code = $row->category_code;
            $product->category_name = $row->category_name;

            $product->unit_code = trim($row->unit_code);
            $product->unit_name = trim($row->unit_name);

            // $product->thumbnail = "https://api.linkinformaticarj.com.br/storage/files/temporary/{$row->barcode}.jpg";
            $product->thumbnail = null;

            if (!empty($row->color_name)) $product->color_name = trim($row->color_name);
            if (!empty($row->size_name)) $product->size_name = trim($row->size_name);

            if ((bool) $row->available_block) $product->available = ($row->available > 0) ? true : false;
            else $product->available = true;
            $product->available_amount = (float) $row->available;

            $product->unit_price = (float) $row->unit_price;

            $product->tributation_code = trim($row->tributation_code);
            $product->ncm_number = trim($row->ncm_number);

            $product->promotion = (bool) $row->promotion;
            if ($product->promotion) :
                // $product->promotion_use_value = (bool) $row->promotion_use_value;
                $product->promotion_use_date = (bool) $row->promotion_use_date;
                if (!$product->promotion_use_date) :
                    $product->promotion_price = (float) $row->promotion_price;
                else :
                    if (strtotime($row->promotion_date_start) <= time() && strtotime($row->promotion_date_end) >= time()) :
                        $product->promotion_date_start = $row->promotion_date_start;
                        $product->promotion_date_end = $row->promotion_date_end;

                        $product->promotion_price = (float) $row->promotion_price;
                    endif;
                endif;
            endif;

            // $product->dim_weight = (float) str_replace(",", ".", $row->weight);
            // $product->dim_weight_real = (float) str_replace(",", ".", $row->weight_real);
            // $product->dim_length = (float) str_replace(",", ".", $row->dim_length);
            // $product->dim_height = (float) str_replace(",", ".", $row->dim_height);
            // $product->dim_width = (float) str_replace(",", ".", $row->dim_width);

            $products[] = $product;
        endforeach;

        $return["products"] = $products;

        return $products;
    }

    public static function getProductsMeta($db, $params = null)
    {
        $select_products = [];
        $select_products["table"] = "`baselink`.`tab_produtos_mix` AS `products`";
        $select_products["columns"] = [
            "`products`.`LOJA` AS `store_code`",
            "`products`.`VENDEDOR` AS `seller_code`",
            "`products`.`CODIGOBARRAS` AS `barcode`",
            "`product`.`DESCRICAO` AS `product_name`",
        ];
        $select_products["joins"][] = ["LEFT", "`baselink`.`produtos` AS `product`", "`products`.`CODIGOBARRAS` = `product`.`CODIGO_BARRAS` AND `products`.`LOJA` = `product`.`CODIGO_LOJA`"];
        if (isset($params["where"])) $select_products["where"] = $params["where"];

        // $select_products["order_by"] = ["orderasc_`product`.`DESCRICAO`"];
        $select_products = (object) $db->select($select_products, true);

        $products = [];
        foreach ($select_products->data as $product) :
            $products[] = $product;
        endforeach;

        $return["products"] = $products;
        $return["select_products"] = $select_products;

        return $products;
    }

    public static function createOrder($db, $data)
    {
        $data = (object) $data;

        $order = [];

        $select_sequencais = (object) $db->select([
            "table" => "`baselink`.`sequenciais`",
            "columns" => ["sequenciais.SEQUENCIAL"],
            "where" => [
                "param_`NOME_TABELA`" => "PEDIDO"
            ]
        ]);

        $sequencial = $select_sequencais->data[0]->SEQUENCIAL + 1;

        // $order_default["NUMERO_PEDIDO"] = $data->order_number ?? substr($data->seller_code, 1) . date("dHis");
        // $order_default["NUMAUXPEDIDO"] = $data->order_number ?? substr($data->seller_code, 1) . date("dHis");

        $data->order_number = ($data->user_prevenda ?? substr($data->seller_code, 1)) . str_pad($sequencial, 8, 0, STR_PAD_LEFT);
        $order_default["NUMERO_PEDIDO"] = $data->order_number;
        $order_default["NUMAUXPEDIDO"] = $data->order_number;

        $order_default["PAGAMENTO"] = strtoupper($data->payment_name);
        $order_default["TIPOVENCIMENTO"] = $data->payment_code;
        // $order["PAGAMENTO"] = $data->payment_name;

        $data->date = date("Y-m-d 00:00:00");
        $order_default["DATA"] = $data->date;

        $order_default["OPERADOR"] = $data->seller_code;
        $order_default["CODIGO_VENDEDOR"] = $data->seller_code;
        $order_default["VENDEDOR"] = $data->seller_name;

        $order_default["CODIGO_CLIENTE"] = $data->customer_code;
        $order_default["CLIENTE"] = $data->customer_name;

        $order_default["NUMPREVENDA"] = ($data->user_prevenda ?? substr($data->seller_code, 1));

        $order_default["COD_LOJA"] = $data->store_code;

        $order_default["ENTREGA"] = 0;
        $order_default["PERCREDST"] = 0;

        $order_default["PEDIDO"] = 0;
        // $order_default["VENDA"] = 0;
        $order_default["TROCA"] = 0;
        $order_default["BONIFICACAO"] = 0;
        $order_default["ORCAMENTO"] = 0;

        switch ($data->order_type):
            case 0:
                $order_default["ORCAMENTO"] = 1;
                break;
            case 1:
                $order_default["PEDIDO"] = 1;
                break;
            case 2:
                // $order_default["PEDIDO"] = 1; //VENDA
                break;
            case 3:
                $order_default["BONIFICACAO"] = 1;
                break;
            case 4:
                $order_default["TROCA"] = 1;
                break;
        endswitch;


        // $order["CODIGO_ROTA"] = $data->route_code;
        // $order["ROTA"] = $data->route_name;
        $order_default["DATAENTREGA"] = date("d/m/Y", strtotime($data->delivery_date ?? "now"));

        $order_default["FV"] = 1;

        $i = 1;
        $insert_data = [];
        foreach ($data->items as $item) :
            $item = (object) $item;
            $select_tributation = [];
            $select_tributation["table"] = "`baselink`.`tab_produtos_tributacao` AS `trib`";
            $select_tributation["columns"] = [
                "`trib`.`CFOP` AS `cfop`",
                "`trib`.`CFOPEXT` AS `cfop_ext`",
                "`trib`.`UFDESTINO` AS `destination_uf`",
            ];
            $select_tributation["where"]["param_`trib`.`LOJA`"] = $data->store_code;
            $select_tributation["where"]["param_`trib`.`VINCULO`"] = $item->tributation_code;
            $select_tributation["where"]["param_`trib`.`UFDESTINO`"] = $data->customer_address_uf;
            $select_tributation["where"]["param_`trib`.`REVENDA`"] = $data->customer_resale;
            $select_tributation = (object) $db->select($select_tributation, true);

            $tributation = $select_tributation->data[0];

            $order = [];
            $order = $order_default;
            // $order["tributation"] = $tributation;
            $order["ITEM"] = $i;

            $order["CODIGO_BARRAS"] = $item->barcode;
            $order["CODIGO_INTERNO"] = $item->barcode;

            $order["CODIGO_TABELA"] = $item->price_table_code ?? "0000";
            $order["PRODUTO"] = $item->name;
            $order["QTD_ITEM"] = $item->amount;
            $order["UNIDADE_MEDIDA"] = $item->unit_code;
            // $order["UNIDADE"] = $item->unit_name;

            $order["DESCONTO_ITEM"] = $item->discount_price;
            $order["VALOR_UNITARIO"] = $item->unit_price;

            $total_price = 0;
            $total_price = $item->unit_price * $item->amount;
            $total_price = $total_price - $item->discount_price;

            $order["VALOR_TOTAL"] = $total_price;
            $order["TOTAL"] = $total_price;

            $order["TIPO_DESCONTO"] = "$";
            $order["ALIQUOTA"] = $item->tributation_code;
            $order["PERCDESC"] = "0";

            $order["OCOMPRA"] = $data->obs_nf;


            $order["CODNCM"] = $item->ncm_code;

            $order["CFOP"] = ($data->store_uf != $tributation->destination_uf) ? $tributation->cfop_ext : $tributation->cfop;

            $i++;
            $insert_data[] = $order;
        endforeach;

        $insert_obs["table"] = "`baselink`.`tab_obspedido1`";
        $insert_obs["data"]["NUMERO_PEDIDO"] = $data->order_number;
        $insert_obs["data"]["OBS"] = $data->obs_order;
        $insert_obs["data"]["DATA"] = $data->date;

        $update_sequencial["table"] = "`baselink`.`sequenciais`";
        $update_sequencial["data"]["sequencial"] = $sequencial;
        $update_sequencial["where"]["param_`sequenciais`.`NOME_TABELA`"] = "PEDIDO";


        $insert_order = [];
        $insert_order["table"] = "`orc_link`.`tab_pedido`";
        $insert_order["data"] = $insert_data;

        // $insert_order = $db->build_insert($insert_order, true);
        $insert_order = (object) $db->insert($insert_order, true);
        if ($insert_order->success) :
            $insert_obs = $db->update($insert_obs);
            $update_sequencial = $db->update($update_sequencial);

            $select_orders = (object) OrderController::list($db, [
                "where" => [
                    "param_`pedido`.`NUMERO_PEDIDO`" => $data->order_number
                ]
            ]);
            $return["success"] = true;
            $return["inserted_order"] = $select_orders->orders[0];
            return $return;
        endif;

        return $insert_order;
    }
}


class OrderController
{
    const query = [
        "table" => "`orc_link`.`tab_pedido` AS `pedido`",
        "columns" => [
            "`pedido`.`NUMERO_PEDIDO` AS `order_number`",

            "DATE(`pedido`.`DATA`) AS `date`",
            "`pedido`.`COD_LOJA` AS `store_id`",

            "`pedido`.`TIPOVENCIMENTO` AS `payment_code`",
            "`pedido`.`PAGAMENTO` AS `payment_method`",

            "'' AS `status`",
            "`pedido`.`CANCELADO` AS `canceled`",
            "`pedido`.`MOTIVOCANCELAMENTO` AS `canceled_reason`",
            "`pedido`.`AUTORIZADO` AS `approved`",
            // "`pedido`.`SEPARADO_TODOS` AS `reserved`",
            "'' AS `reserved`",
            "`pedido`.`EXPEDIDO` AS `dispatched`",
            "`pedido`.`FECHADO` AS `billed`",
            "`pedido`.`CARREGADO` AS `loaded_truck`",

            "'' AS `type`",
            "`pedido`.`PREVENDA` AS `pre`",
            "`pedido`.`PEDIDO` AS `order`",
            "`pedido`.`TROCA` AS `trade`",
            "`pedido`.`ORCAMENTO` AS `budget`",
            "`pedido`.`BONIFICACAO` AS `bonus`",

            "'' AS `seller`",
            "`pedido`.`CODIGO_VENDEDOR` AS `seller_id`",
            "`pedido`.`VENDEDOR` AS `seller_name`",
            "`pedido`.`FV` AS `salesforce`",

            "'' AS `customer`",
            "`pedido`.`CODIGO_CLIENTE` AS `customer_id`",
            "`pedido`.`CLIENTE` AS `customer_name`",
            "`pedido`.`CNPJCLIENTE` AS `customer_doc`",

            "COUNT(`pedido`.`CODIGO_BARRAS`) AS `items_total`",
            "SUM(`pedido`.`TOTAL`) AS `price_value`",

            "`pedido`.`PRIORIDADE` AS `priority`",
            "`pedido`.`CODIGO_ROTA` AS `route_id`",
            "`pedido`.`ROTA` AS `route_name`",
            "`pedido`.`NUMENTREGA` AS `delivery_id`",
            "`pedido`.`DATAENTREGA` AS `delivery_date`",

            "`entrega`.`SITUACAO` AS `delivery_status`",
            "`entrega`.`CANCELADA` AS `delivery_canceled`",

            "GROUP_CONCAT(`pedido`.`CODIGO_BARRAS`) AS products_barcode",
            "GROUP_CONCAT(`produto`.`GTIN`) AS products_gtin",
            "GROUP_CONCAT(`pedido`.`PRODUTO`) AS products_name",
            "GROUP_CONCAT(`pedido`.`VALOR_UNITARIO`) AS products_unit_price",
            "GROUP_CONCAT(`pedido`.`VALOR_TOTAL`) AS products_price",
            "GROUP_CONCAT(`produto`.`POSICAO_ESTOQ_ITEM`) AS products_available",
            "GROUP_CONCAT(`pedido`.`QTD_ITEM`) AS products_amount",
            "GROUP_CONCAT(`unidades`.`UNIDADE`) AS products_unit",
            "GROUP_CONCAT(`produto`.`LOCAL`) AS products_location",

            "GROUP_CONCAT(`pedido`.`SEPARADO`) AS products_reserved",
            "GROUP_CONCAT(`pedido`.`CONFERIDO`) AS products_checked",
            "GROUP_CONCAT(`pedido`.`CARREGADO`) AS products_loaded",
            "GROUP_CONCAT(`pedido`.`ENTREGA`) AS products_delivered",
            // "SUM(`pedido`.`QTD_ITEM`) AS volume",
        ],

        "joins" => [
            ["LEFT", "`baselink`.`tab_entrega` AS `entrega`", "`entrega`.`NUMENTRGA` = `pedido`.`NUMENTREGA`"],
            ["LEFT", "`baselink`.`tab_unidade` AS `unidades`", "`pedido`.`UNIDADE_MEDIDA` = `unidades`.`CODIGO`"],
            ["LEFT", "`baselink`.`produtos` AS `produto`", "`produto`.`CODIGO_BARRAS` = `pedido`.`CODIGO_BARRAS` AND `produto`.`CODIGO_LOJA` = `pedido`.`COD_LOJA`"],
        ],

        "group_by" => "`pedido`.`NUMERO_PEDIDO`",
        "order_by" => "`pedido`.`DATA` DESC, `pedido`.`NUMERO_PEDIDO` ASC, `pedido`.`PRODUTO` ASC",
        // "limit" => 1,
    ];

    const order_timeline = [
        "opened" => "Aberto",
        "approved" => "Aprovado",
        "reserved" => "Separado",
        "dispatched" => "Expedido",
        "billed" => "Faturado",
        "loaded_truck" => "Carregado",
        "on_route" => "Em rota",
        "delivered" => "Entregue",
        "canceled" => "Cancelado",
    ];

    const order_types = [
        "sell" => "Venda",
        "budget" => "Orçamento",
        "pre" => "Prévenda",
        "trade" => "Troca",
        "bonus" => "Bonificação",
    ];

    public static function setStatus($field, $value)
    {
        $status[] = [$field, $value];

        return $status;
    }

    public static function format(object $data)
    {
        // LOJA
        $data->store_id = (int) $data->store_id;

        // Vendedor
        $data->seller = [
            "id" => (int) $data->seller_id,
            "name" => Helpers::getName($data->seller_name),
        ];
        unset($data->seller_id, $data->seller_name);

        // Cliente
        $data->customer = [
            "id" => (int) $data->customer_id,
            "name" => trim($data->customer_name),
        ];
        unset($data->customer_id, $data->customer_name, $data->customer_doc);

        // TIPO DE PEDIDO
        $order_type = ["id" => "sell", "name" => "Venda"];
        foreach (self::order_types as $type => $value) :
            $order_types[$type] = (bool) $data->$type;
            if ($data->$type == 1) $order_type = ["id" => $type, "name" => self::order_types[$type]];
            unset($data->$type);
        endforeach;
        $data->type = $order_type;
        unset($data->pre, $data->trade, $data->budget, $data->order);

        // STATUS DO PEDIDO
        $order_timeline = ["id" => "open", "name" => "Aberto"];
        foreach (self::order_timeline as $status => $value) :
            $order_timeline_id[$status] = (bool) $data->$status;
            if ($data->$status == 1) $order_timeline = ["id" => $status, "name" => self::order_timeline[$status]];
            unset($data->$status);
        endforeach;
        if ($order_type["id"] === "sell") $order_timeline_id["opened"] = (bool) 1;

        if (!$data->canceled) unset($data->canceled_reason);

        // ENTREGA
        if (!empty($data->delivery_id)) :
            $delivery = [];
            $data->priority = !empty($data->priority) ? (int) $data->priority : 0;
            $delivery["delivery_id"] = !empty($data->delivery_id) ? (float) $data->delivery_id : null;
            $delivery["delivery_date"] = !empty($data->delivery_date) ? Helpers::dateTranslate($data->delivery_date) : null;

            $data->route_id = !empty($data->route_id) ? (int) $data->route_id : null;
            $delivery["route"] = !empty($data->route_name) ? trim("{$data->route_id} {$data->route_name}") : $data->route_id;

            $data->delivery_canceled = (bool) $data->delivery_canceled;
            $data->delivery_status = (int) $data->delivery_status;

            $delivery["status"] = null;
            if ($data->delivery_canceled === true) :
                $delivery["status"] = 0;
                $order_timeline = ["status_id" => "delivery_canceled", "name" => "Entrega Cancelada"];
            elseif ($data->delivery_status === 1) :
                $delivery["status"] = $data->delivery_status;
                $order_timeline = ["status_id" => "delivered", "name" => "Entrega Concluída"];
            elseif ($data->delivery_status === 2) :
                $delivery["status"] = $data->delivery_status;
                $order_timeline = ["status_id" => "on_route", "name" => "Em rota"];
            endif;

            $data->delivery = $delivery;

            unset(
                $data->priority,
                $data->delivery_id,
                $data->delivery_date,
                $data->route_id,
                $data->route_name,
                $data->delivery_status,
                $data->delivery_canceled
            );
        endif;

        // FINALIZAÇÃO
        $data->salesforce = (bool) $data->salesforce;

        $data->items_total = (int) $data->items_total;
        $data->price_value = (float) $data->price_value;

        $order_timeline["timeline"] = $order_timeline_id;
        $data->status = $order_timeline;

        // PRODUTOS
        $product_fields = [
            "products_barcode",
            "products_gtin",
            "products_name",
            "products_available",
            "products_amount",
            "products_unit_price",
            "products_unit",
            "products_location",

            "products_reserved",
            "products_checked",
            "products_loaded",
            "products_delivered",
        ];
        foreach ($product_fields as $field) :
            $$field = explode(",", $data->$field);

            unset($data->$field);
        endforeach;

        $counter = 0;
        $volume = 0;
        for ($counter = 0; $counter < count($products_barcode); $counter++) :
            $product = (object) [];
            $product->barcode = $products_barcode[$counter];
            $product->gtin = $products_gtin[$counter];
            $product->name = $products_name[$counter];
            $product->available = (float) $products_available[$counter];
            $product->amount = (float) $products_amount[$counter];
            $product->unit_price = (float) $products_unit_price[$counter];
            $product->unit = $products_unit[$counter];
            $product->location = $products_location[$counter];

            $volume = $volume + $product->amount;

            $product->reserved = (bool) $products_reserved[$counter] ?? false;
            $product->checked = (bool) $products_checked[$counter] ?? false;
            $product->loaded = (bool) $products_loaded[$counter] ?? false;
            $product->delivered = (bool) $products_delivered[$counter] ?? false;

            // $select_product = [];
            // $select_product["table"] = "`baselink`.`produtos`";
            // $select_product["where"]["param_`produtos`.`CODIGO_BARRAS`"] = $product->barcode;
            // $select_product["columns"] = ["`produtos`.`GTIN` as `gtin_code`"];

            if (!$product->reserved) $data->status["timeline"]["reserved"] = false;
            if (!$product->checked) $data->status["timeline"]["dispatched"] = false;
            if (!$product->loaded) $data->status["timeline"]["loaded_truck"] = false;
            if (!$product->delivered) $data->status["timeline"]["delivered"] = false;

            $products[$product->barcode] = $product;
        endfor;

        $data->itens_volume = $volume;
        $data->products = $products;

        return $data;
    }

    public static function list($db, array $params = [])
    {
        $return["success"] = false;

        $query = self::query;
        $query["where"] = $params["where"];
        $query["order_by"] = $params["order"];
        // $query["limit"] = 20;

        // exit(print_r($select_orders, true));
        // $select_orders = $db->build_select($query);

        $select_orders = (object) $db->select($query);
        // $return = $select_orders;
        /* */
        if (!$select_orders->success) :
            $return["error"] = $select_orders;
        else :
            $return["results"] = $select_orders->results;
            // $return["total"] = (isset($select_orders->total)) ? $select_orders->total : $select_orders->results;

            $orders = [];

            foreach ($select_orders->data as $row) :
                $row = self::format($row);

                $orders[] = $row;
            endforeach;

            $return["orders"] = $orders;
            $return["success"] = true;
        endif;
        /* */

        return $return;
    }
}
