<?php

error_reporting(E_ERROR);

require(__DIR__ . "/../vendor/autoload.php");

if (preg_match('/\.(?:png|jpg|jpeg|gif|zip)$/', $_SERVER["REQUEST_URI"])) {
    return false;
}

use EDGVI10\Helpers;
use EDGVI10\DBWalker;
use Linkinfo\Functions;
use Linkinfo\OrderController;
use Slim\App as App;
use Slim\Http\Request as Request;
use Slim\Http\Response as Response;

Helpers::cors();

$env = Helpers::getEnv(__DIR__ . "/../.env");
$pkg = (object) json_decode(file_get_contents(__DIR__ . "/../composer.json"));

$debug = isset($env->debug) ? (bool) $env->debug : false;

setlocale(LC_TIME, 'pt_BR', 'pt_BR.iso-8859-1', 'pt_BR.utf-8', 'portuguese');
date_default_timezone_set('America/Sao_Paulo');

$mysql_access = [
    $env->mysql_host,
    Functions::encrypt($env->mysql_user),
    Functions::encrypt($env->mysql_pass),
    $env->mysql_base,
];

$config = ["settings" => ["displayErrorDetails" => true]];

$slim = new App($config);

$slim->get("[/]", function (Request $request, Response $response, array $args) {
    global $pkg;
    global $mysql_access;

    $return = [];
    $return["success"] = true;
    $return["version"] = $pkg->version;

    return $response->withJson($return, 200);
});

include_once __DIR__ . "/../Routes/admin.php";

$slim->group("/v1", function ($slim) {
    $slim->group("/{company_slug}", function ($slim) {
        $slim->get("/check/{user_code}", function (Request $request, Response $response, $args) {
            $return = [];
            $return["success"] = false;
            $db = new DBWalker(["api.linkinformaticarj.com.br", Functions::encrypt("g`a~c=>"), Functions::encrypt("#@c~8@g~y="), "link"]);

            $select_users = $db->select([
                "table" => "fv_access",
                "where" => [
                    "param_company_slug" => "{$args["company_slug"]}",
                    "param_user_code" => "{$args["user_code"]}",
                ]
            ]);

            $user = $select_users["data"][0];
            $return["user"] = $user;
            if ($user->user_prevenda === null) :
                $return["message"] = "Usuário FV não liberado";
            else :
                // if ($user->session_active == 1) :
                //     $return["message"] = "Usuário ligado em {$user->session_device}";
                // else :
                $return["prevenda"] = $user->user_prevenda;
                $return["success"] = true;
            // endif;
            endif;

            return $response->withJson($return);
        });

        $slim->get("/logout/{user_code}", function (Request $request, Response $response, $args) {
            $return = [];
            $return["success"] = false;
            $db = new DBWalker(["api.linkinformaticarj.com.br", Functions::encrypt("g`a~c=>"), Functions::encrypt("#@c~8@g~y="), "link"]);

            $select_users = $db->select([
                "table" => "fv_access",
                "where" => [
                    "param_company_slug" => "{$args["company_slug"]}",
                    "param_user_code" => "{$args["user_code"]}",
                ]
            ]);

            $user = $select_users["data"][0];
            $return["user"] = $user;
            if ($user->user_prevenda === null) :
                $return["message"] = "Usuário FV não liberado";
            else :
                // if ($user->session_active == 1) :
                //     $return["message"] = "Usuário ligado em {$user->session_device}";
                // else :
                // $return[""]
                $return["prevenda"] = $user->user_prevenda;
                $return["success"] = true;
            // endif;
            endif;

            return $response->withJson($return);
        });

        $slim->get("[/]", function (Request $request, Response $response, $args) {
            $return = [];
            $return["success"] = false;
            $company_slug = $args["company_slug"];
            $localenv = Helpers::getEnv(__DIR__ . "/../Config/{$company_slug}.env");

            $pkg = (object) json_decode(file_get_contents(__DIR__ . "/../composer.json"));

            $mysql_access = [
                $localenv->mysql_host,
                Functions::encrypt($localenv->mysql_user),
                Functions::encrypt($localenv->mysql_pass),
                $localenv->mysql_base,
            ];

            $db = new DBWalker($mysql_access);
            $data = $request->getParsedBody();

            $select_stores = [];
            $select_stores["table"] = "`baselink`.`lojas`";
            $select_stores["columns"] = [
                "`lojas`.`COD_LOCAL` AS `store_cod`",
                "`lojas`.`COD_LOCAL` AS `code`",
                "`lojas`.`NOME` AS `name`",
                "`lojas`.`TELEFONE` AS `phone`",
                "`lojas`.`CPF_CGC` AS `document`",
                "`lojas`.`ESTADO` AS `address_state`",
            ];

            $select_stores = (object) $db->select($select_stores, true);

            $stores = [];
            foreach ($select_stores->data as $row) :
                $store = (object) [];

                $store->code = $row->code;
                $store->name = trim($row->name);
                $store->document = Helpers::extractInt($row->document);
                $store->phone = ltrim(Helpers::extractInt($row->phone), 0);
                $store->address_state = mb_strtoupper($row->address_state);

                $stores[] = $store;
            endforeach;

            $return["success"] = true;
            $return["server"] = [
                "company_name" => $localenv->company_name,
                "company_slug" => $company_slug,
                "url" => (isset($_SERVER['HTTPS']) && $_SERVER['HTTPS'] === 'on' ? "https" : "http") . "://$_SERVER[HTTP_HOST]$_SERVER[REQUEST_URI]",
                "version" => $pkg->version,
                "stores" => $stores,
            ];

            return $response->withJson($return, 200);
        });

        $slim->get("/stores", function (Request $request, Response $response, $args) {
            $return = [];
            $return["success"] = false;
            $company_slug = $args["company_slug"];
            $localenv = Helpers::getEnv(__DIR__ . "/../Config/{$company_slug}.env");

            $mysql_access = [
                $localenv->mysql_host,
                Functions::encrypt($localenv->mysql_user),
                Functions::encrypt($localenv->mysql_pass),
                $localenv->mysql_base,
            ];

            $db = new DBWalker($mysql_access);

            $data = (object) $request->getParsedBody();

            $select_stores = [];
            $select_stores["table"] = "`baselink`.`lojas`";
            $select_stores["columns"] = [
                "`lojas`.`COD_LOCAL` AS `store_cod`",
                "`lojas`.`COD_LOCAL` AS `code`",
                "`lojas`.`NOME` AS `name`",
                "`lojas`.`CPF_CGC` AS `document`",
                "`lojas`.`ESTADO` AS `address_state`",
            ];

            $select_stores = (object) $db->select($select_stores, true);

            $stores = [];
            foreach ($select_stores->data as $store) :
                // $store->document = Helpers::extractInt($store->document);
                $stores[] = $store;
            endforeach;

            $return["stores"] = $stores;
            $return["success"] = true;

            return $response->withJson($return, 200);
        });

        $slim->post("/login", function (Request $request, Response $response, $args) {
            $return = [];
            $return["success"] = false;
            $company_slug = $args["company_slug"];
            $localenv = Helpers::getEnv(__DIR__ . "/../Config/{$company_slug}.env");

            $mysql_access = [
                $localenv->mysql_host,
                Functions::encrypt($localenv->mysql_user),
                Functions::encrypt($localenv->mysql_pass),
                $localenv->mysql_base,
            ];

            // $return["localenv"] = $mysql_access;

            $db = new DBWalker($mysql_access);

            $data = (object) $request->getParsedBody();


            $user_params["where"]["param_`lojas`.`CPF_CGC`"] = $data->cnpj ?? $data->document;
            $user_params["where"]["param_`operadores`.`NOME`"] = Functions::encrypt(strtoupper(Helpers::normalize($data->username)));
            $user_params["where"]["param_`operadores`.`SENHA`"] = Functions::encrypt($data->password);
            $user_params["where"]["param_`operadores`.`ATIVO`"] = 1;

            $users = Functions::getUser($db, $user_params);
            // $return["debug"]["user_params"] = $user_params;
            // $return["debug"]["user"] = $users;

            $user = $users[0];

            if (count($user) > 0) :
                $return["user"] = $user;
                $return["token"] = Helpers::base64url_encode("{$user->uuid}-{$user->store_code}");
                $return["success"] = true;
            else :
                $return["message"] = "Combinação usuário e senha inválida.";
            endif;

            return $response->withJson($return, 200);
        });

        $slim->post("/users", function (Request $request, Response $response, $args) {
            $return = [];
            $return["success"] = false;
            $company_slug = $args["company_slug"];
            $localenv = Helpers::getEnv(__DIR__ . "/../Config/{$company_slug}.env");

            $mysql_access = [
                $localenv->mysql_host,
                Functions::encrypt($localenv->mysql_user),
                Functions::encrypt($localenv->mysql_pass),
                $localenv->mysql_base,
            ];
            $db = new DBWalker($mysql_access);

            $data = (object) $request->getParsedBody();

            $user_params["where"]["param_`lojas`.`CPF_CGC`"] = $data->cnpj ?? $data->document;
            $user_params["where"]["param_`operadores`.`ATIVO`"] = 1;

            $return = Functions::getUser($db, $user_params);


            return $response->withJson($return, 200);
        });

        $slim->group("/{user_token}", function ($slim) {
            $slim->get("/tables", function (Request $request, Response $response, $args) {
                $return = [];
                $return["success"] = false;
                $company_slug = $args["company_slug"];
                $localenv = Helpers::getEnv(__DIR__ . "/../Config/{$company_slug}.env");

                $mysql_access = [
                    $localenv->mysql_host,
                    Functions::encrypt($localenv->mysql_user),
                    Functions::encrypt($localenv->mysql_pass),
                    $localenv->mysql_base,
                ];

                $db = new DBWalker($mysql_access);

                $data = (object) $request->getParsedBody();

                $price_tables = Functions::getPriceTables($db);
                $return["price_tables"] = $price_tables;
                $return["success"] = true;

                return $response->withJson($return, 200);
            });

            $slim->get("/products-meta", function (Request $request, Response $response, $args) {
                $user_token = explode("-", Helpers::base64url_decode($args["user_token"]));

                $user_uuid = $user_token[0];
                $store_code = $user_token[1];

                $return = [];
                $return["success"] = false;
                $company_slug = $args["company_slug"];
                $localenv = Helpers::getEnv(__DIR__ . "/../Config/{$company_slug}.env");

                $mysql_access = [
                    $localenv->mysql_host,
                    Functions::encrypt($localenv->mysql_user),
                    Functions::encrypt($localenv->mysql_pass),
                    $localenv->mysql_base,
                ];

                $db = new DBWalker($mysql_access);

                $data = (object) $request->getParsedBody();

                $user_params = [];
                $user_params["where"]["param_`operadores`.`COD_LOJA`"] = $store_code;
                $user_params["where"]["raw"][] = "MD5(`operadores`.`CODIGO`) = '{$user_uuid}'";

                $user = Functions::getUser($db, $user_params);
                $user = $user[0];

                $products_meta = [];
                $products_meta_params["where"]["param_`products`.`LOJA`"] = $store_code;
                $products_meta_params["where"]["raw"][] = "MD5(`products`.`VENDEDOR`) = '{$user_uuid}'";
                $products_meta = Functions::getProductsMeta($db, $products_meta_params);

                $return["user"] = $user;
                $return["products_meta"] = $products_meta;
                $return["success"] = true;

                return $response->withJson($return, 200);
            });

            $slim->get("/departments", function (Request $request, Response $response, $args) {
                $user_token = explode("-", Helpers::base64url_decode($args["user_token"]));

                $user_uuid = $user_token[0];
                $store_code = $user_token[1];

                $company_slug = $args["company_slug"];
                $localenv = Helpers::getEnv(__DIR__ . "/../Config/{$company_slug}.env");
                $mysql_access = [
                    $localenv->mysql_host,
                    Functions::encrypt($localenv->mysql_user),
                    Functions::encrypt($localenv->mysql_pass),
                    $localenv->mysql_base,
                ];

                $db = new DBWalker($mysql_access);

                $data = (object) $request->getParsedBody();

                $return = [];
                $return["success"] = false;

                $user_params = [];
                $user_params["where"]["param_`operadores`.`COD_LOJA`"] = $store_code;
                $user_params["where"]["raw"][] = "MD5(`operadores`.`CODIGO`) = '{$user_uuid}'";

                $user = Functions::getUser($db, $user_params);
                $user = $user[0];
                $departments = Functions::getDepartments($db);

                $return["user"] = $user;
                $return["departments"] = $departments;
                $return["success"] = true;

                return $response->withJson($return, 200);
            });

            $slim->get("/categories", function (Request $request, Response $response, $args) {
                $user_token = explode("-", Helpers::base64url_decode($args["user_token"]));

                $user_uuid = $user_token[0];
                $store_code = $user_token[1];

                $company_slug = $args["company_slug"];
                $localenv = Helpers::getEnv(__DIR__ . "/../Config/{$company_slug}.env");
                $mysql_access = [
                    $localenv->mysql_host,
                    Functions::encrypt($localenv->mysql_user),
                    Functions::encrypt($localenv->mysql_pass),
                    $localenv->mysql_base,
                ];

                $db = new DBWalker($mysql_access);

                $data = (object) $request->getParsedBody();

                $return = [];
                $return["success"] = false;

                $user_params = [];
                $user_params["where"]["param_`operadores`.`COD_LOJA`"] = $store_code;
                $user_params["where"]["raw"][] = "MD5(`operadores`.`CODIGO`) = '{$user_uuid}'";

                $user = Functions::getUser($db, $user_params);
                $user = $user[0];
                $categories = Functions::getCategories($db);

                $return["user"] = $user;
                $return["categories"] = $categories;
                $return["success"] = true;

                return $response->withJson($return, 200);
            });

            $slim->get("/payments", function (Request $request, Response $response, $args) {
                $user_token = explode("-", Helpers::base64url_decode($args["user_token"]));

                $user_uuid = $user_token[0];
                $store_code = $user_token[1];

                $company_slug = $args["company_slug"];
                $localenv = Helpers::getEnv(__DIR__ . "/../Config/{$company_slug}.env");
                $mysql_access = [
                    $localenv->mysql_host,
                    Functions::encrypt($localenv->mysql_user),
                    Functions::encrypt($localenv->mysql_pass),
                    $localenv->mysql_base,
                ];

                $db = new DBWalker($mysql_access);

                $data = (object) $request->getParsedBody();

                $return = [];
                $return["success"] = false;

                $user_params = [];
                $user_params["where"]["param_`operadores`.`COD_LOJA`"] = $store_code;
                $user_params["where"]["raw"][] = "MD5(`operadores`.`CODIGO`) = '{$user_uuid}'";

                $user = Functions::getUser($db, $user_params);
                $user = $user[0];
                $methods = Functions::getPaymentMethods($db);

                $return["user"] = $user;
                $return["methods"] = $methods;
                $return["success"] = true;

                return $response->withJson($return, 200);
            });

            $slim->get("/customers", function (Request $request, Response $response, $args) {
                $user_token = explode("-", Helpers::base64url_decode($args["user_token"]));

                $user_uuid = $user_token[0];
                $store_code = $user_token[1];

                $company_slug = $args["company_slug"];
                $localenv = Helpers::getEnv(__DIR__ . "/../Config/{$company_slug}.env");
                $mysql_access = [
                    $localenv->mysql_host,
                    Functions::encrypt($localenv->mysql_user),
                    Functions::encrypt($localenv->mysql_pass),
                    $localenv->mysql_base,
                ];

                $db = new DBWalker($mysql_access);

                $data = (object) $request->getParsedBody();

                $return = [];
                $return["success"] = false;

                $user_params = [];
                $user_params["where"]["param_`operadores`.`COD_LOJA`"] = $store_code;
                $user_params["where"]["raw"][] = "MD5(`operadores`.`CODIGO`) = '{$user_uuid}'";

                $user = Functions::getUser($db, $user_params);
                $user = $user[0];
                $customers_params["where"]["param_`clientes`.`CODIGO_VENDEDOR`"] = $user->code;
                $customers_params["where"]["param_`clientes`.`CINATIVO`"] = 0;
                $customers = Functions::getCustomers($db, $customers_params);

                $return["user"] = $user;
                $return["customers"] = $customers;
                $return["success"] = true;

                return $response->withJson($return, 200);
            });

            $slim->get("/products", function (Request $request, Response $response, $args) {
                $user_token = explode("-", Helpers::base64url_decode($args["user_token"]));

                $user_uuid = $user_token[0];
                $store_code = $user_token[1];

                $company_slug = $args["company_slug"];
                $localenv = Helpers::getEnv(__DIR__ . "/../Config/{$company_slug}.env");
                $mysql_access = [
                    $localenv->mysql_host,
                    Functions::encrypt($localenv->mysql_user),
                    Functions::encrypt($localenv->mysql_pass),
                    $localenv->mysql_base,
                ];

                $db = new DBWalker($mysql_access);

                $data = (object) $request->getParsedBody();

                $return = [];
                $return["success"] = false;

                $user_params = [];
                $user_params["where"]["param_`operadores`.`COD_LOJA`"] = $store_code;
                $user_params["where"]["raw"][] = "MD5(`operadores`.`CODIGO`) = '{$user_uuid}'";

                $user = Functions::getUser($db, $user_params);
                $user = $user[0];

                $products_params = [];
                $products_params["where"]["param_`product`.`CODIGO_LOJA`"] = $user->store_code;
                $products = Functions::getProducts($db, $products_params);

                $return["user"] = $user;
                $return["products"] = $products;
                $return["success"] = true;

                return $response->withJson($return, 200);
            });

            $slim->group("/orders", function ($slim) {
                $slim->post("[/]", function (Request $request, Response $response, $args) {
                    $return = [];
                    $return["success"] = false;
                    $company_slug = $args["company_slug"];
                    $localenv = Helpers::getEnv(__DIR__ . "/../Config/{$company_slug}.env");
                    $mysql_access = [
                        $localenv->mysql_host,
                        Functions::encrypt($localenv->mysql_user),
                        Functions::encrypt($localenv->mysql_pass),
                        $localenv->mysql_base,
                    ];

                    $db = new DBWalker($mysql_access);
                    $data = $request->getParsedBody();

                    $return["success"] = false;
                    $inserted_order = (object) Functions::createOrder($db, $data);
                    $return = $inserted_order;

                    return $response->withJson($return, 200);
                });

                $slim->get("[/{order_uuid}]", function (Request $request, Response $response, $args) {
                    $user_token = explode("-", Helpers::base64url_decode($args["user_token"]));

                    $user_uuid = $user_token[0];
                    $store_code = $user_token[1];

                    $company_slug = $args["company_slug"];
                    $localenv = Helpers::getEnv(__DIR__ . "/../Config/{$company_slug}.env");
                    $mysql_access = [
                        $localenv->mysql_host,
                        Functions::encrypt($localenv->mysql_user),
                        Functions::encrypt($localenv->mysql_pass),
                        $localenv->mysql_base,
                    ];

                    $db = new DBWalker($mysql_access);

                    $data = (object) $request->getParsedBody();

                    $return = [];
                    $return["success"] = false;

                    $user_params = [];
                    $user_params["where"]["param_`operadores`.`COD_LOJA`"] = $store_code;
                    $user_params["where"]["raw"][] = "MD5(`operadores`.`CODIGO`) = '{$user_uuid}'";

                    $user = Functions::getUser($db, $user_params);
                    $user = $user[0];

                    $orders_params = [];
                    $orders_params["where"]["param_`pedido`.`CODIGO_VENDEDOR`"] = $user->code;
                    if (isset($_GET["open"])) :
                        $orders_params["where"]["param_`pedido`.`FECHADO`"] = 0;
                    endif;
                    if (isset($_GET["order_number"])) :
                        $orders_params["where"]["param_`pedido`.`NUMAUXPEDIDO`"] = $_GET["order_number"];
                    endif;
                    $orders_params["where"]["param_`pedido`.`CANCELADO`"] = 0;
                    $list_orders = OrderController::list($db, $orders_params);

                    $return["user"] = $user;
                    $return["orders"] = $list_orders["orders"];
                    $return["success"] = true;

                    return $response->withJson($return, 200);
                });
            });
        });

        $slim->get("/sync/{user_uuid}", function (Request $request, Response $response, $args) {
            $return = [];
            $return["success"] = false;
            $return["user"] = false;
            $return["departments"] = false;
            $return["categories"] = false;
            $return["products"] = false;

            $company_slug = $args["company_slug"];
            $localenv = Helpers::getEnv(__DIR__ . "/../Config/{$company_slug}.env");
            $mysql_access = [
                $localenv->mysql_host,
                Functions::encrypt($localenv->mysql_user),
                Functions::encrypt($localenv->mysql_pass),
                $localenv->mysql_base,
            ];

            $db = new DBWalker($mysql_access);

            $data = (object) $request->getParsedBody();

            $select_users = [];
            $select_users["table"] = "`operadores`";
            $select_users["columns"] = [
                "'' AS `uuid`",
                "`operadores`.`CODIGO` AS `cod`",
                "`lojas`.`COD_LOCAL` AS `store_cod`",
                "`lojas`.`NOME` AS `store_name`",
                "`operadores`.`NOME_OPERADOR` AS `name`",
                "`operadores`.`DESCONTO` AS `max_discount`",
                "`operadores`.`ATIVO` AS `active`",
            ];

            $select_users["joins"][] = ["RIGHT", "`lojas`", "`lojas`.`COD_LOCAL` = `operadores`.`COD_LOJA`"];

            $select_users["where"]["raw"][] = "MD5(`operadores`.`CODIGO`) = '{$args["user_uuid"]}'";

            $users = [];

            $select_users = (object) $db->select($select_users, true);
            // $return["debug"]["select_users"] = $select_users;

            foreach ($select_users->data as $user) :
                $user->uuid = md5($user->cod);
                $user->max_discount = (float) $user->max_discount;

                // SELECIONA CLIENTES DO VENDEDOR ==========================================================================================================
                $customers_params["where"]["param_`clientes`.`CODIGO_VENDEDOR`"] = $user->code;
                $user->customers = Functions::getCustomers($db, $customers_params);

                // SELECIONA TABELAS DE PREÇO ==========================================================================================================
                $return["price_tables"] = Functions::getPriceTables($db);


                // PRODUTOS ==========================================================================================================
                $select_products = [];
                $select_products["table"] = "`baselink`.`produtos` AS `product`";
                $select_products["columns"] = [
                    "`product`.`CODIGO_BARRAS` AS `barcode`",
                    "`product`.`DESCRICAO` AS `name`",

                    "`product`.`VALOR_VENDA` AS `unit_price`",
                    "`product`.`UNIDADE` AS `unit_code`",
                    "`unit`.`UNIDADE` AS `unit_name`",
                ];
                $select_products["joins"][] = ["LEFT", "`tab_unidade` AS `unit`", "`unit`.`CODIGO` = `product`.`UNIDADE`"];


                // $select_products["where"]["param_`dpt`.``"] = $_GET[""];
                $select_products["where"]["param_`product`.`CODIGO_LOJA`"] = $user->store_cod;

                $select_products["order_by"] = ["orderasc_`product`.`DESCRICAO`"];
                $select_products["limit"] = 10;
                $select_products = (object) $db->select($select_products, true);

                $return["debug"]["select_products"] = $select_products;

                $products = [];
                $user->max_discount = 5;
                foreach ($select_products->data as $row) :
                    $product = (object) [];
                    $product->name = str_replace("  ", " ", trim($row->name));

                    $product->unit_price = (float) $row->unit_price;
                    $product->max_discount = (float) $user->max_discount / 100;
                    $product->unit_price_min = ($user->max_discount != 0) ? (($user->max_discount / 100) * $row->unit_price) : $row->unit_price;

                    $products[] = $product;
                endforeach;

                $return["products"] = $products;

                $users[] = $user;
            endforeach;

            if (count($select_users->data) > 0) :
                $return["user"] = $users[0];

                $return["departments"] = Functions::getDepartments($db);
                $return["categories"] = Functions::getCategories($db);
                $return["success"] = true;
            endif;


            // unset($return["user"]);
            unset($return["user"]->customers);
            unset($return["user"]->price_tables);
            // unset($return["departments"]);
            unset($return["categories"]);

            return $response->withJson($return, 200);
        });
    });
});

// Run application
$slim->run();
