<?php

use EDGVI10\DBWalker;
use Slim\Http\Request;
use Slim\Http\Response;

$linode_access = ["api.linkinformaticarj.com.br", "public", "!Link2remote)", "link"];
class FVAdmin
{
    public static function check($params = [])
    {
    }

    public static function users($params = [])
    {
        global $linode_access;
        $db = new DBWalker($linode_access);

        $return["success"] = false;

        $select_users["table"] = "`link`.`fv_access` AS `user`";
        if (isset($params["where"])) $select_users["where"] = $params["where"];
        if (isset($params["order_by"])) $select_users["order_by"] = $params["order_by"];

        $select_users = $db->select($select_users);

        $return = $select_users;

        return $return;
    }

    public static function createUser($data = [], $debug = false)
    {
        global $linode_access;
        $db = new DBWalker($linode_access);

        $return["success"] = false;

        $select_users = self::users([
            "where" => [
                "param_`user`.`company_document`" => $data["company_document"],
                "param_`user`.`user_code`" => $data["user_code"],
            ]
        ]);

        if ($select_users["results"] !== 0) :
            $return["message"] = "Usuário " . mb_strtoupper($data["user_name"]) . " ({$data["user_code"]}) já cadastrado para a loja " . mb_strtoupper($data["company_name"]) . " ({$data["company_document"]})";
        else :
            $data["uuid"] = $db->UUID();
            $data["user_name"] = mb_strtolower($data["user_name"]);

            $insert_access = [];
            $insert_access["table"] = "`link`.`fv_access`";
            $insert_access["data"] = $data;

            $insert_access = $db->insert($insert_access);
            if ($insert_access["affected_rows"] > 0) :
                $data["id"] = $insert_access["insert_id"];

                $insert_access["created_data"] = $data;
            endif;

            $return = $insert_access;
        endif;

        return $return;
    }
}

$slim->group("/admin", function ($slim) {
    $slim->get("/users", function (Request $request, Response $response, $args) {
        $return["success"] = false;

        $return = FVAdmin::users();

        return $response->withJson($return);
    });

    $slim->post("/users", function (Request $request, Response $response, $args) {
        $return["success"] = false;

        $data = $request->getParsedBody();

        $return = FVAdmin::createUser($data);

        return $response->withJson($return);
    });
});
