<?php

namespace Linkinfo;

use EDGVI10\Helpers;

class IfoodController
{
    public static function getCatalog($merchant_id, $access_token)
    {
        $return["success"] = false;

        $base_url = "https://merchant-api.ifood.com.br/catalog/v1.0/merchants/{$merchant_id}";

        $call = [];
        $call["method"] = "GET";
        $call["endpoint"] = "{$base_url}/catalogs";
        $call["headers"]["Authorization"] = $access_token;

        $call = (object) Helpers::call($call);
        $return["debug"]["call"] = $call;
        $catalogs = [];
        foreach ($call->response as $item) :
            $catalog = (object) [];
            $catalog->uuid = $item["catalogId"];
            $catalog->status = $item["status"];
            $catalog->context = $item["context"][0];

            $catalogs[$item["context"][0]] = $catalog;
        endforeach;

        $return["response"] = $catalogs;
        $return["success"] = true;

        return $return;
    }

    public static function getCategory($merchant_id, $catalog_id, $access_token)
    {
        $return["success"] = false;

        $base_url = "https://merchant-api.ifood.com.br/catalog/v1.0/merchants/{$merchant_id}";

        $call = [];
        $call["method"] = "GET";
        $call["endpoint"] = "{$base_url}/catalogs/{$catalog_id}/categories";
        $call["headers"]["Authorization"] = $access_token;

        $call = (object) Helpers::call($call);
        $return["debug"]["call"] = $call;
        $categories = [];
        foreach ($call->response as $item) :
            $category = (object) [];
            $category->uuid = $item["id"];
            $category->status = $item["status"];
            $category->code = str_pad($item["externalCode"], 4, 0, STR_PAD_LEFT);
            $category->name = $item["name"];

            $categories[] = $category;
        endforeach;

        $return["response"] = $categories;
        $return["success"] = true;

        return $return;
    }

    public static function createCategory($data, $merchant_id, $catalog_id, $access_token)
    {
        $return["success"] = false;

        $base_url = "https://merchant-api.ifood.com.br/catalog/v1.0/merchants/{$merchant_id}";

        $call = [];
        $call["method"] = "POST";
        $call["endpoint"] = "{$base_url}/catalogs/{$catalog_id}/categories";
        $call["headers"]["Authorization"] = $access_token;
        $call["data"] = [
            "name" => $data->name,
            "externalCode" => $data->code,
            "status" => "AVAILABLE",
            "template" => "DEFAULT",
        ];

        $call = (object) Helpers::call($call);
        $return["debug"]["call"] = $call;
        if ($call->response["error"]) :
            $return["message"] = $call->response["error"]["message"];
            $return["success"] = false;
        else :
            $categories = [];

            $item = $call->response;

            $category = (object) [];

            $category->uuid = $item["id"];
            $category->code = $item["externalCode"];
            $category->status = $item["status"];
            $category->name = $item["name"];

            $categories[] = $category;

            $return["response"] = $categories;
            $return["success"] = true;
        endif;

        return $return;
    }

    public static function createProduct($merchant_id, $access_token, $data)
    {
    }

    public static function createProductItem($merchant_id, $access_token, $data)
    {

        $call = [];
        $call["method"] = "GET";
        $call["endpoint"] = "https://merchant-api.ifood.com.br/catalog/v1.0/merchants/{$merchant_id}/categories/{$data->categoryId}/products/{$data->productId}";
        $call["headers"]["Authorization"] = $access_token;

        $product_item = (object) [];
        return $product_item;
    }
}
