<?php

error_reporting(E_ALL ^ E_NOTICE);

use EDGVI10\DBWalker;
use \Slim\App as App;
use \Slim\Http\Request as Request;
use \Slim\Http\Response as Response;

use \EDGVI10\Helpers;

require __DIR__ . "/../vendor/autoload.php";

Helpers::cors();

define("DEBUG", false);

setlocale(LC_TIME, 'pt_BR', 'pt_BR.iso-8859-1', 'pt_BR.utf-8', 'portuguese');
date_default_timezone_set('America/Sao_Paulo');

$config = ["settings" => ["displayErrorDetails" => true]];

$app = new App($config);

$app->get("[/]", function (Request $request, Response $response, array $args) {
    $return["success"] = true;
    $pkg = (object) json_decode(file_get_contents(__DIR__ . "/../composer.json"));

    $package["description"] = $pkg->description;
    $package["version"] = $pkg->version;
    $package["authors"] = $pkg->authors;

    $return["package"] = $package;

    return $response->withJson($return, 200);
});

include_once __DIR__ . "/../Routes/auth.php";
$app->group("/{merchantId}", function ($app) {
    include_once __DIR__ . "/../Routes/catalogs.php";
    include_once __DIR__ . "/../Routes/categories.php";
    include_once __DIR__ . "/../Routes/products.php";
    include_once __DIR__ . "/../Routes/orders.php";
});
/* */
// Run application
$app->run();
