<?php

use EDGVI10\Helpers;
use Slim\Http\Request;
use Slim\Http\Response;

$app->post("/auth", function (Request $request, Response $response, array $args) {
    $return["success"] = false;
    $data = (object) $request->getParsedBody();

    $base_url = "https://merchant-api.ifood.com.br/authentication/v1.0";
    $auth = [];
    $auth["method"] = "POST";
    $auth["endpoint"] = "{$base_url}/oauth/userCode";

    $auth["data"] = [];

    $auth["data"]["clientId"] = $data->clientId;

    $auth["headers"]["Content-Type"] = "application/x-www-form-urlencoded";
    $auth["headers"]["accept"] = "application/json";

    $req = (object) Helpers::call($auth);

    $return["response"] = $req->response;
    $return["success"] = true;

    return $response->withJson($return, 200);
});

$app->post("/token", function (Request $request, Response $response, array $args) {
    $return["success"] = false;

    $data = (object) $request->getParsedBody();

    // $return["debug"]["body"] = $request->getParsedBody();

    $base_url = "https://merchant-api.ifood.com.br/authentication/v1.0";
    $auth = [];
    $auth["method"] = "POST";
    $auth["endpoint"] = "{$base_url}/oauth/token";

    $auth["data"] = [];

    $auth["data"]["clientId"] = $data->clientId;
    $auth["data"]["clientSecret"] = $data->clientSecret;

    if (isset($data->refreshToken) && !empty($data->refreshToken)) :
        $auth["data"]["grantType"] = "refresh_token";
        $auth["data"]["refreshToken"] = $data->refreshToken;
    else :
        $auth["data"]["grantType"] = "authorization_code";
        $auth["data"]["authorizationCode"] = $data->authorizationCode;
        $auth["data"]["authorizationCodeVerifier"] = $data->authorizationCodeVerifier;
    endif;

    $auth["headers"]["Content-Type"] = "application/x-www-form-urlencoded";
    $auth["headers"]["accept"] = "application/json";

    $req = (object) Helpers::call($auth);

    if ($req->response["accessToken"]) :
        $return["response"] = $req->response;
        $return["success"] = true;
    endif;

    return $response->withJson($return, 200);
});
