<?php

use EDGVI10\Helpers;
use Linkinfo\IfoodController;
use Slim\Http\Request;
use Slim\Http\Response;

$app->group("/catalogs", function ($app) {
    $app->get("", function (Request $request, Response $response, array $args) {
        $return["success"] = false;

        $base_url = "https://merchant-api.ifood.com.br/catalog/v1.0/merchants/{$args["merchantId"]}";

        $header = (object) $request->getHeaders();
        $data = (object) $request->getParsedBody();

        $catalogs = (object) IfoodController::getCatalog($args["merchantId"], $header->HTTP_AUTHORIZATION[0]);

        $return["response"] = $catalogs->response;
        $return["success"] = true;

        return $response->withJson($return, 200);
    });
});
