<?php

use EDGVI10\Helpers;
use Linkinfo\IfoodController;
use Slim\Http\Request;
use Slim\Http\Response;

$app->group("/categories", function ($app) {
    $app->get("", function (Request $request, Response $response, array $args) {
        $return["success"] = false;

        $header = (object) $request->getHeaders();
        $data = (object) $request->getParsedBody();

        $base_url = "https://merchant-api.ifood.com.br/catalog/v1.0/merchants/{$args["merchantId"]}";

        $merchant_id = $args["merchantId"];
        $access_token = $header->HTTP_AUTHORIZATION[0];

        // $return["debug"]["body"] = $request->getParsedBody();

        $catalogs = IfoodController::getCatalog($merchant_id, $access_token);
        $catalog = $catalogs["response"]["DEFAULT"];
        $catalog_id = $catalog->uuid;

        $get_categories = IfoodController::getCategory($merchant_id, $catalog_id, $access_token);

        // $return["debug"]["categories"] = $get_categories["response"];
        $categories = [];
        foreach ($get_categories["response"] as $item) :
            $category = (object) $item;

            $categories[] = $category;
        endforeach;

        $return["catalog"] = $catalog;
        $return["categories"] = $categories;
        $return["success"] = true;

        return $response->withJson($return, 200);
    });

    $app->post("", function (Request $request, Response $response, array $args) {
        $return["success"] = false;

        $header = (object) $request->getHeaders();
        $data = (object) $request->getParsedBody();

        $base_url = "https://merchant-api.ifood.com.br/catalog/v1.0/merchants/{$args["merchantId"]}";

        $merchant_id = $args["merchantId"];
        $access_token = $header->HTTP_AUTHORIZATION[0];


        $catalogs = IfoodController::getCatalog($merchant_id, $access_token);
        $catalog = $catalogs["response"]["DEFAULT"];
        $catalog_id = $catalog->uuid;

        if (!empty($data->uuid)) :
            $data->uuid = Helpers::uuid();
        endif;

        $create_category = IfoodController::createCategory($data, $merchant_id, $catalog_id, $access_token);

        $return["success"] = $create_category["success"];
        $return["catalog"] = $catalog;

        $return["debug"]["categories"] = $create_category;
        if (!$create_category["success"]) :
            $return["message"] = $create_category["message"];
        else :
            $categories = [];
            foreach ($create_category["response"] as $item) :
                $category = (object) $item;

                $categories[] = $category;
            endforeach;

            $return["categories"] = $categories;
        endif;

        return $response->withJson($return, 200);
    });
});
