<?php

use EDGVI10\Helpers;
use Linkinfo\IfoodController;
use Slim\Http\Request;
use Slim\Http\Response;

$app->group("/products", function ($app) {
    $app->get("[/{productId}]", function (Request $request, Response $response, array $args) {
        $return["success"] = false;

        $base_url = "https://merchant-api.ifood.com.br/catalog/v1.0/merchants/{$args["merchantId"]}";

        $header = (object) $request->getHeaders();
        $data = (object) $request->getParsedBody();

        // $return["debug"]["body"] = $request->getParsedBody();

        $products = [];
        $products["method"] = "GET";
        $products["endpoint"] = "{$base_url}/products";
        $products["data"]["page"] = (int) $_GET["page"];
        $products["data"]["limit"] = (int) $_GET["limit"];

        $products["headers"]["Authorization"] = $header->HTTP_AUTHORIZATION[0];
        // $return["debug"] = $products;

        $call = (object) Helpers::call($products, true);
        // $return["call"] = $call;
        $return["response"] = $call->response;
        $return["success"] = true;

        return $response->withJson($return, 200);
    });

    $app->post("", function (Request $request, Response $response, array $args) {
        $return["success"] = false;
        $header = (object) $request->getHeaders();
        $data = (object) $request->getParsedBody();

        $catalogs = IfoodController::getCatalog($args["merchantId"], $header->HTTP_AUTHORIZATION[0]);
        $catalogId = $catalogs["response"][$data->catalog];

        $product = (object) [];
        $product->uuid = Helpers::uuid();
        $product->catalogId = $catalogId->uuid;
        $product->externalCode = $data->code;
        $product->name = $data->name;
        $product->description = $data->description;
        $product->image = $data->image;
        $product->serving = $data->serving;

        $return["product"] = $product;

        foreach ($data->items as $item) :
            $item = (object) $item;
            $item->status = "AVAILABLE";

            $return["items"][] = $item;
        endforeach;

        $return["success"] = true;

        return $response->withJson($return, 200);
    });
});
