<?php

namespace Linkinfo;

use EDGVI10\DBWalker;
use EDGVI10\Helpers;

class OrderController
{
    const query = [
        "table" => "`orc_link`.`tab_pedido` AS `pedido`",
        "columns" => [
            "`pedido`.`NUMERO_PEDIDO` AS `order_number`",

            "DATE(`pedido`.`DATA`) AS `date`",
            "`pedido`.`COD_LOJA` AS `store_id`",

            "'' AS `status`",
            "`pedido`.`CANCELADO` AS `canceled`",
            "`pedido`.`MOTIVOCANCELAMENTO` AS `canceled_reason`",
            "`pedido`.`AUTORIZADO` AS `approved`",
            "`pedido`.`SEPARADO_TODOS` AS `reserved`",
            "`pedido`.`EXPEDIDO` AS `dispatched`",
            "`pedido`.`FECHADO` AS `billed`",
            "`pedido`.`CARREGADO` AS `loaded_truck`",

            "'' AS `type`",
            "`pedido`.`PREVENDA` AS `pre`",
            "`pedido`.`PEDIDO` AS `order`",
            "`pedido`.`TROCA` AS `trade`",
            "`pedido`.`ORCAMENTO` AS `budget`",
            "`pedido`.`BONIFICACAO` AS `bonus`",

            "'' AS `seller`",
            "`pedido`.`CODIGO_VENDEDOR` AS `seller_id`",
            "`pedido`.`VENDEDOR` AS `seller_name`",
            "`pedido`.`FV` AS `salesforce`",

            "'' AS `customer`",
            "`pedido`.`CODIGO_CLIENTE` AS `customer_id`",
            "`pedido`.`CLIENTE` AS `customer_name`",
            "`pedido`.`CNPJCLIENTE` AS `customer_doc`",

            "COUNT(`pedido`.`CODIGO_BARRAS`) AS `items_total`",
            "SUM(`pedido`.`TOTAL`) AS `price_value`",

            "`pedido`.`PRIORIDADE` AS `priority`",
            "`pedido`.`CODIGO_ROTA` AS `route_id`",
            "`pedido`.`ROTA` AS `route_name`",
            "`pedido`.`NUMENTREGA` AS `delivery_id`",
            "`pedido`.`DATAENTREGA` AS `delivery_date`",

            "`entrega`.`SITUACAO` AS `delivery_status`",
            "`entrega`.`CANCELADA` AS `delivery_canceled`",

            "GROUP_CONCAT(`pedido`.`CODIGO_BARRAS`) AS products_barcode",
            "GROUP_CONCAT(`produto`.`GTIN`) AS products_gtin",
            "GROUP_CONCAT(`pedido`.`PRODUTO`) AS products_name",
            "GROUP_CONCAT(`pedido`.`TOTAL`) AS products_price",
            "GROUP_CONCAT(`produto`.`POSICAO_ESTOQ_ITEM`) AS products_available",
            "GROUP_CONCAT(`pedido`.`QTD_ITEM`) AS products_amount",
            "GROUP_CONCAT(`unidades`.`UNIDADE`) AS products_unit",
            "GROUP_CONCAT(`produto`.`LOCAL`) AS products_location",

            "GROUP_CONCAT(`pedido`.`SEPARADO`) AS products_reserved",
            "GROUP_CONCAT(`pedido`.`CONFERIDO`) AS products_checked",
            "GROUP_CONCAT(`pedido`.`CARREGADO`) AS products_loaded",
            "GROUP_CONCAT(`pedido`.`ENTREGA`) AS products_delivered",
            // "SUM(`pedido`.`QTD_ITEM`) AS volume",
        ],

        "joins" => [
            ["LEFT", "`baselink`.`tab_entrega` AS `entrega`", "`entrega`.`NUMENTRGA` = `pedido`.`NUMENTREGA`"],
            ["LEFT", "`baselink`.`tab_unidade` AS `unidades`", "`pedido`.`UNIDADE_MEDIDA` = `unidades`.`CODIGO`"],
            ["LEFT", "`baselink`.`produtos` AS `produto`", "`produto`.`CODIGO_BARRAS` = `pedido`.`CODIGO_BARRAS`"],
        ],

        "group_by" => "`pedido`.`NUMERO_PEDIDO`",
        "order_by" => "`pedido`.`NUMERO_PEDIDO` ASC, `pedido`.`PRODUTO` ASC, `pedido`.`DATA` ASC",
        // "limit" => 1,
    ];

    const order_timeline = [
        "opened" => "Aberto",
        "approved" => "Aprovado",
        "reserved" => "Separado",
        "dispatched" => "Expedido",
        "billed" => "Faturado",
        "loaded_truck" => "Carregado",
        "on_route" => "Em rota",
        "delivered" => "Entregue",
        "canceled" => "Cancelado",
    ];

    const order_types = [
        "sell" => "Venda",
        "budget" => "Orçamento",
        "pre" => "Prévenda",
        "trade" => "Troca",
        "bonus" => "Bonificação",
    ];

    public static function setStatus($field, $value)
    {
        $status[] = [$field, $value];

        return $status;
    }

    public static function format(object $data)
    {
        // LOJA
        $data->store_id = (int) $data->store_id;

        // Vendedor
        $data->seller = [
            "id" => (int) $data->seller_id,
            "name" => Helpers::getName($data->seller_name),
        ];
        unset($data->seller_id, $data->seller_name);

        // Cliente
        $data->customer = [
            "id" => (int) $data->customer_id,
            "name" => trim($data->customer_name),
        ];
        unset($data->customer_id, $data->customer_name, $data->customer_doc);

        // TIPO DE PEDIDO
        $order_type = ["id" => "sell", "name" => "Venda"];
        foreach (self::order_types as $type => $value) :
            $order_types[$type] = (bool) $data->$type;
            if ($data->$type == 1) $order_type = ["id" => $type, "name" => self::order_types[$type]];
            unset($data->$type);
        endforeach;
        $data->type = $order_type;
        unset($data->pre, $data->trade, $data->budget, $data->order);

        // STATUS DO PEDIDO
        $order_timeline = ["id" => "open", "name" => "Aberto"];
        foreach (self::order_timeline as $status => $value) :
            $order_timeline_id[$status] = (bool) $data->$status;
            if ($data->$status == 1) $order_timeline = ["id" => $status, "name" => self::order_timeline[$status]];
            unset($data->$status);
        endforeach;
        if ($order_type["id"] === "sell") $order_timeline_id["opened"] = (bool) 1;

        if (!$data->canceled) unset($data->canceled_reason);

        // ENTREGA
        if (!empty($data->delivery_id)) :
            $delivery = [];
            $data->priority = !empty($data->priority) ? (int) $data->priority : 0;
            $delivery["delivery_id"] = !empty($data->delivery_id) ? (float) $data->delivery_id : null;
            $delivery["delivery_date"] = !empty($data->delivery_date) ? Helpers::dateTranslate($data->delivery_date) : null;

            $data->route_id = !empty($data->route_id) ? (int) $data->route_id : null;
            $delivery["route"] = !empty($data->route_name) ? trim("{$data->route_id} {$data->route_name}") : $data->route_id;

            $data->delivery_canceled = (bool) $data->delivery_canceled;
            $data->delivery_status = (int) $data->delivery_status;

            $delivery["status"] = null;
            if ($data->delivery_canceled === true) :
                $delivery["status"] = 0;
                $order_timeline = ["status_id" => "delivery_canceled", "name" => "Entrega Cancelada"];
            elseif ($data->delivery_status === 1) :
                $delivery["status"] = $data->delivery_status;
                $order_timeline = ["status_id" => "delivered", "name" => "Entrega Concluída"];
            elseif ($data->delivery_status === 2) :
                $delivery["status"] = $data->delivery_status;
                $order_timeline = ["status_id" => "on_route", "name" => "Em rota"];
            endif;

            $data->delivery = $delivery;

            unset(
                $data->priority,
                $data->delivery_id,
                $data->delivery_date,
                $data->route_id,
                $data->route_name,
                $data->delivery_status,
                $data->delivery_canceled
            );
        endif;

        // FINALIZAÇÃO
        $data->salesforce = (bool) $data->salesforce;

        $data->items_total = (int) $data->items_total;
        $data->price_value = (float) $data->price_value;

        $order_timeline["timeline"] = $order_timeline_id;
        $data->status = $order_timeline;

        // PRODUTOS
        $product_fields = [
            "products_barcode",
            "products_gtin",
            "products_name",
            "products_available",
            "products_amount",
            "products_price",
            "products_unit",
            "products_location",

            "products_reserved",
            "products_checked",
            "products_loaded",
            "products_delivered",
        ];
        foreach ($product_fields as $field) :
            $$field = explode(",", $data->$field);

            unset($data->$field);
        endforeach;

        $counter = 0;
        for ($counter = 0; $counter < count($products_barcode); $counter++) :
            $product = (object) [];
            $product->barcode = $products_barcode[$counter];
            $product->gtin = $products_gtin[$counter];
            $product->name = $products_name[$counter];
            $product->available = (float) $products_available[$counter];
            $product->amount = (float) $products_amount[$counter];
            $product->unit = $products_unit[$counter];
            $product->location = $products_location[$counter];

            $volume = $volume + $product->amount;

            $product->reserved = (bool) $products_reserved[$counter] ?? false;
            $product->checked = (bool) $products_checked[$counter] ?? false;
            $product->loaded = (bool) $products_loaded[$counter] ?? false;
            $product->delivered = (bool) $products_delivered[$counter] ?? false;

            // $select_product = [];
            // $select_product["table"] = "`baselink`.`produtos`";
            // $select_product["where"]["param_`produtos`.`CODIGO_BARRAS`"] = $product->barcode;
            // $select_product["columns"] = ["`produtos`.`GTIN` as `gtin_code`"];

            if (!$product->reserved) $data->status["timeline"]["reserved"] = false;
            if (!$product->checked) $data->status["timeline"]["dispatched"] = false;
            if (!$product->loaded) $data->status["timeline"]["loaded_truck"] = false;
            if (!$product->delivered) $data->status["timeline"]["delivered"] = false;

            $products[$product->barcode] = $product;
        endfor;

        $data->itens_volume = $volume;
        $data->products = $products;

        return $data;
    }

    public static function list(array $params = [])
    {
        global $debug;
        global $mysql_access;

        // exit(json_encode($mysql_access));
        $db = new DBWalker($mysql_access);

        $return["success"] = false;

        $query = self::query;
        $query["where"] = $params["where"];
        $query["order_by"] = $params["order"];
        // $query["limit"] = 20;

        // exit(print_r($select_orders, true));
        // $select_orders = $db->build_select($query);

        $select_orders = (object) $db->select($query, true);
        $return["debug"] = $select_orders;
        /* */
        if (!$select_orders->success) :
            $return["error"] = $select_orders;
        else :
            $return["results"] = $select_orders->results;
            // $return["total"] = (isset($select_orders->total)) ? $select_orders->total : $select_orders->results;

            $orders = [];

            foreach ($select_orders->data as $row) :
                $row = self::format($row);

                $orders[] = $row;
            endforeach;

            $return["orders"] = $orders;
            $return["success"] = true;
        endif;
        /* */

        return $return;
    }
}
