<?php

namespace Linkinfo;

use Edgvi10\DBWalker;

class ProductController
{
    const query = [
        "table" => "`baselink`.`produtos` AS prod",
        "columns" => [
            "prod.CODIGO_BARRAS AS barcode",
            "prod.DESCRICAO AS name",
            "prod.POSICAO_ESTOQ_ITEM AS available",
            "prod.CODIGO_CATEGORIA AS cat_id",
        ],
        "where" => [
            "param_insumo" => 0,
            "param_inativo" => 0,
            "param_excluir" => 0,
            "param_prod.produto" => 1,
        ]
    ];

    public function format(object $data, bool $debug = false)
    {
        return $data;
    }

    public function list($params = [])
    {
        global $mysql_access;

        $db = new DBWalker($mysql_access);

        $query = self::query;

        $query["limit"] = 10;
        $select_products = (object) $db->build_select($query, true);

        return $select_products;
    }
}
