<?php

error_reporting(E_ERROR);

require(__DIR__ . "/../vendor/autoload.php");
require(__DIR__ . "/../vendor/edgvi10/phphelpers/src/Helpers.php");
require(__DIR__ . "/../vendor/edgvi10/phphelpers/src/DBWalker.php");

if (preg_match('/\.(?:png|jpg|jpeg|gif|zip)$/', $_SERVER["REQUEST_URI"])) {
    return false;    // serve the requested resource as-is.
}

use chillerlan\QRCode\QRCode;
use \Linkinfo\Functions;

use \EDGVI10\Helpers;
use \EDGVI10\DBWalker as DB;
use EDGVI10\DBWalker;
use Linkinfo\OrderController;
use \Slim\App as App;
use \Slim\Http\Request as Request;
use \Slim\Http\Response as Response;

Helpers::cors();

$env = Helpers::getEnv(__DIR__ . "/../.env");
$pkg = (object) json_decode(file_get_contents(__DIR__ . "/../composer.json"));

$debug = $env->debug ?? false;

setlocale(LC_TIME, 'pt_BR', 'pt_BR.iso-8859-1', 'pt_BR.utf-8', 'portuguese');
date_default_timezone_set('America/Sao_Paulo');

$mysql_access = [
    $env->mysql_host,
    Functions::encrypt($env->mysql_user),
    Functions::encrypt($env->mysql_pass),
    $env->mysql_base,
];

// $mysql_access = ["191.242.104.29", "public", "!Dev2Link)", "baselink"]; 
// $mysql_access = ["linkinformaticarj.ddns.com.br", "public", "!teste2link", "baselink"];

$config = ["settings" => ["displayErrorDetails" => true]];

$slim = new App($config);


$slim->get("[/]", function (Request $request, Response $response, array $args) {
    global $pkg;
    global $mysql_access;

    $return = [];
    $return["success"] = true;
    $return["version"] = $pkg->version;

    // $return["debug"] = $mysql_access;

    $db = new DB($mysql_access);
    $return["token"] = $db->UUID();

    $return["ORIGIN"] = $_SERVER["HTTP_ORIGIN"];
    $return["REFERER"] = $_SERVER["HTTP_REFERER"];
    $return["HOST"] = $_SERVER["HTTP_HOST"];
    $return["SERVER"] = $_SERVER;

    return $response->withJson($return, 200);
});

$slim->post("/envgen", function (Request $request, Response $response, array $args) {
    $data = (object) $request->getParsedBody();

    $return["success"] = true;
    $return["env"] = [
        "MYSQL_HOST" => $data->host,
        "MYSQL_USER" => Functions::encrypt($data->user),
        "MYSQL_PASS" => Functions::encrypt($data->pass),
        "MYSQL_BASE" => $data->base,
    ];

    return $response->withJson($return, 200);
});

$slim->group("/v1/print", function ($slim) {
    $slim->get("/separation", function (Request $request, Response $response, array $args) {
        $return = [];
        $return["success"] = false;

        $get = (object) $_GET;
?>
        <form action="/v1/print/separation/generate" method="get" target="_blank">
            Código do pedido:
            <input type="tel" name="order_number">
            <button type="submit">Gerar QRCode</button>
        </form>
    <?php
    });

    $slim->get("/separation/generate", function (Request $request, Response $response, array $args) {
        $return = [];
        $return["success"] = false;

        $get = (object) $_GET;

        global $mysql_access;
        $db = new DBWalker($mysql_access);

        $select_order = [];
        $select_order["table"] = "`orc_link`.`tab_pedido` AS `pedido`";
        $select_order["columns"] = [
            "pedido.NUMERO_PEDIDO",
            "pedido.CUPOM",
            "pedido.SERIE",
            "pedido.COD_LOJA",
            "pedido.DATA",

            "pedido.CODIGO_VENDEDOR",
            "pedido.VENDEDOR",

            "pedido.CODIGO_CLIENTE",
            "pedido.CLIENTE",
            "cliente.NOME AS CLIENTE_NOME",
            "cliente.FANTASIA AS CLIENTE_FANTASIA",
            "cliente.CPF_CGC AS CLIENTE_DOCUMENTO",

            "pedido.CODIGO_BARRAS",
            "produto.GTIN",

            "pedido.PRODUTO",
            "pedido.QTD_ITEM",
            "unidade.UNIDADE",
            "pedido.UNIDADE_MEDIDA",

            "produto.LOCAL",
            "produto.POSICAO_ESTOQ_ITEM",

            "pedido.AUTORIZADO",

            "pedido.SEPARADO",
            "pedido.SEPARADO_TODOS",
            "pedido.CONFERIDO",
            "pedido.EXPEDIDO",
            "pedido.AUTEXPEDIDO",
            "pedido.FECHADO",
            "pedido.CARREGADO",
            "pedido.ENTREGA",

            "pedido.DATAEMBARQUE",
            "pedido.HORAIEMBARQUE",
            "pedido.HORAFEMBARQUE",

            "pedido.INICIOEMBARQUE",
            "pedido.FIMEMBARQUE",

            "pedido.DATAENTREGA",
            "pedido.NUMENTREGA",
        ];
        $select_order["joins"][] = ["LEFT", "`baselink`.`produtos` AS `produto`", "`pedido`.`COD_LOJA` = `produto`.`CODIGO_LOJA` AND `pedido`.`CODIGO_BARRAS` = `produto`.`CODIGO_BARRAS`"];
        $select_order["joins"][] = ["LEFT", "`baselink`.`tab_unidade` AS `unidade`", "`pedido`.`UNIDADE_MEDIDA` = `unidade`.`CODIGO_UNIDADE`"];
        $select_order["joins"][] = ["LEFT", "`baselink`.`tab_entrega` AS `entrega`", "`pedido`.`NUMENTREGA` = `entrega`.`NUMENTRGA`"];
        $select_order["joins"][] = ["LEFT", "`orc_link`.`clientes` AS `cliente`", "`pedido`.`CODIGO_CLIENTE` = `cliente`.`CODIGO_CLIENTE`"];
        $select_order["where"]["param_`pedido`.`NUMERO_PEDIDO`"] = $get->order_number;
        $select_order["where"]["param_`pedido`.`CANCELADO`"] = 0;

        // if (isset($_GET["separation"])) $select_order["where"]["param_`pedido`.`SEPARADO_TODOS`"] = 0;

        // if (isset($_GET["dispatch"])) $select_order["where"]["param_`pedido`.`SEPARADO_TODOS`"] = 1;
        // if (isset($_GET["dispatch"])) $select_order["where"]["param_`pedido`.`EXPEDIDO`"] = 0;

        // if (isset($_GET["truckload"])) $select_order["where"]["param_`pedido`.`EXPEDIDO`"] = 1;
        // if (isset($_GET["truckload"])) $select_order["where"]["param_`pedido`.`FECHADO`"] = 1;
        // if (isset($_GET["truckload"])) $select_order["where"]["not_`entrega`.`VEICULO`"] = "";

        $select_order = (object) $db->select($select_order);

        $order = (object)[];
        $products = [];
        // $order->select_order = $select_order;
        $current_order = null;
        foreach ($select_order->data as $row) :
            $order->number = $row->NUMERO_PEDIDO;
            $order->cupom = $row->CUPOM;
            $order->cupom_serie = $row->SERIE;

            $order->seller_code = $row->CODIGO_VENDEDOR;
            $order->seller_name = $row->VENDEDOR;

            $order->customer_code = $row->CODIGO_CLIENTE;
            $order->customer_name = $row->CLIENTE_NOME;
            $order->customer_fancyname = $row->CLIENTE_FANTASIA;
            $order->customer_document = $row->CLIENTE_DOCUMENTO;

            $order->delivery_number = $row->NUMENTREGA;
            $order->delivery_date = date("d/m/y", strtotime(implode("-", explode("/", $row->DATAENTREGA))));

            $order_product = (object)[];
            $order_product->barcode = $row->CODIGO_BARRAS;
            $order_product->gtin = $row->GTIN;
            $order_product->requested_amount = (float) ($row->QTD_ITEM);
            $order_product->name = $row->PRODUTO;
            $order_product->unit_name = $row->UNIDADE;

            $order_product->location = $row->LOCAL;
            $order_product->available = (float) $row->POSICAO_ESTOQ_ITEM;
            if (!isset($order->products_reserved)) $order->products_reserved = 0;
            if (!isset($order->products_dispatched)) $order->products_dispatched = 0;
            if (!isset($order->products_loaded)) $order->products_loaded = 0;
            if (!isset($order->products_delivered)) $order->products_delivered = 0;

            if ((bool)$row->SEPARADO) $order->products_reserved = $order->products_reserved + 1;
            if ((bool)$row->CONFERIDO) $order->products_dispatched = $order->products_dispatched + 1;
            if ((bool)$row->CARREGADO) $order->products_loaded = $order->products_loaded + 1;
            if ((bool)$row->ENTREGA) $order->products_delivered = $order->products_delivered + 1;

            $order_product->reserved = (bool)$row->SEPARADO;
            $order_product->dispatched = (bool)$row->CONFERIDO;
            $order_product->loaded = (bool)$row->CARREGADO;
            $order_product->delivered = (bool)$row->ENTREGA;

            $order_products[$order_product->barcode] = $order_product;

            $order->products[] = $order_product;
            $current_order = $order->number;
        endforeach;

        $string_qr = [];
        foreach ($order_products as $product) :
            if ($product->reserved) $string_qr[] = "{$product->barcode},{$product->requested_amount}";
            $products[] = $product;
        endforeach;

        $string_qr = implode(";", $string_qr);
        if (empty($string_qr)) exit("Nenhum produto separado");
        // exit(json_encode($order_products));
        $qr = new QRCode();

        $return["qrstring"] = $string_qr;
        $return["qrcode"] = $qr->render($string_qr);

    ?>
        <!DOCTYPE html>
        <html lang="pt-br">

        <head>
            <meta charset="UTF-8">
            <meta http-equiv="X-UA-Compatible" content="IE=edge">
            <meta name="viewport" content="width=device-width, initial-scale=1.0">
            <title>Impressão do pedido: <?= $order->number ?></title>
        </head>

        <body>
            <style>
                * {
                    margin: 0;
                    padding: 0;
                }

                @page {
                    margin: 5mm;
                    /* size: 62mm; */
                }

                body {
                    padding: 0 12px;
                    font-family: monospace;
                    text-align: center;
                    font-size: 12px;
                    line-height: 150%;
                }

                @media print {
                    body {
                        padding: 0;
                    }
                }

                img {
                    display: block;
                    margin: 0 auto;
                    width: 100%;
                    /* max-width: 200px; */
                    height: auto;
                }

                hr {
                    margin: 15px auto;
                    width: 80%;
                    border: 0;
                    border-top: 2px solid #212121;
                }

                table {
                    width: 100%;
                    border: none
                }

                .table-header {
                    margin-top: 12px;
                }

                h4 {
                    font-size: 10px;
                }


                .text-left {
                    text-align: left;
                }

                .text-right {
                    text-align: right;
                }

                .flex-row {
                    display: flex;
                    flex-direction: row;
                    justify-content: space-between;
                    gap: 2px;
                }

                .flex-column {
                    display: flex;
                    flex-direction: column;
                    gap: 2px;
                }
            </style>
            <script>
                window.onload = function() {
                    window.print();
                    setTimeout(() => {
                        // window.alert("Pode fechar a janela");
                        // window.close();
                    }, 5000);
                }
            </script>

            <header>
                <div class="flex-column">

                    <div class="flex-row">
                        <div class="col text-left">
                            <small style="font-size: 9px; display:block">Carga:</small>
                            <b style="font-size: 20px"><?= str_pad($order->delivery_number, 6, "0", STR_PAD_LEFT); ?></b>
                        </div>
                        <div class="col text-right">
                            <small style="font-size: 9px; display:block">Entrega:</small>
                            <b style="font-size: 20px"><?= $order->delivery_date ?></b>
                        </div>
                    </div>

                    <div class="flex-column text-left" style="margin-top: 6px;">
                        <h3><?= $order->customer_fancyname === "" ? $order->customer_name : $order->customer_fancyname; ?></h3>
                        <p>DOC: <?= Helpers::mask("##.###.###/####-##", $order->customer_document) ?></p>
                    </div>


                    <div class="flex-row" style="margin-top: 6px; font-size: 12px;">
                        <p class="col text-left">PEDIDO: <?= "{$order->number}" ?></p>
                        <p class="col text-left">NF: <?= "{$order->cupom}/{$order->cupom_serie}" ?></p>
                    </div>
                </div>
            </header>


            <div>
                <img src="<?= $return["qrcode"]; ?>">
                <hr>

                <div style="font-size: 10px; text-align: left">
                    <?php $reserved = 0;
                    foreach ($products as $product) :
                        if ($product->reserved) : $reserved++; ?>
                            <div class="flex-row" style="justify-content: start; gap: 5px; line-height: 100%; margin-bottom: 4px;">
                                <div class="min-width: 20px"><?= $product->requested_amount . strtoupper($product->unit_name) ?></div>
                                <div><?= $product->name ?></div>
                            </div>
                    <?php endif;
                    endforeach; ?>
                </div>
                <br />

                <small><?= "Separado {$reserved} de " . count($products) ?></small>
            </div>
            <p>--fim</p>
        </body>

        </html>
<?php
        $return["order"] = $order;
        // $return["products"] = $products;

        // return $response->withJson($return, 200);
    });
});

$slim->get("/routes", function (Request $request, Response $response, array $args) {
    $return = [];
    $return["success"] = true;

    global $slim;
    $routes = $slim->getContainer()->router->getRoutes();
    // And then iterate over $routes

    $endpoints = [];
    foreach ($routes as $route) {
        $endpoints[] = [
            "methods" => "[" . implode("], [", $route->getMethods()) . "]",
            "endpoint" => $route->getPattern(),
        ];
    }

    $return["endpoints"] = $endpoints;

    return $response->withJson($return, 200);
});

include __DIR__ . "/../Routes/stores.php";
include __DIR__ . "/../Routes/login.php";
$slim->group("/{token}", function ($slim) {
    $slim->group("/v1", function ($slim) {
        $slim->get("/deliveries", function (Request $request, Response $response, $args) {
            $return["success"] = false;

            global $mysql_access;
            $db = new DBWalker($mysql_access);

            $select_entregas["table"] = "`orc_link`.`tab_pedido` AS `pedido`";
            $select_entregas["columns"] = [
                "pedido.NUMENTREGA",
                "entrega.ROTA",
                "entrega.DATAENTREGA",
            ];
            $select_entregas["joins"][] = ["LEFT", "`baselink`.`tab_entrega` AS `entrega`", "`pedido`.NUMENTREGA = `entrega`.NUMENTRGA"];
            $select_entregas["group_by"] = "pedido.NUMENTREGA";

            $select_entregas["where"]["param_pedido.AUTORIZADO"] = 1;
            $select_entregas["where"]["param_pedido.SEPARADO"] = 0;
            $select_entregas["where"]["param_pedido.ORCAMENTO"] = 0;
            $select_entregas["where"]["param_pedido.CANCELADO"] = 0;
            $select_entregas["where"]["param_pedido.FECHADO"] = 0;
            $select_entregas["where"]["raw"][] = "(`pedido`.`FV` = 1 AND `pedido`.`AUTORIZACAOFV` = 1 OR `pedido`.`FV` = 0)";

            // if ($args["filter"] === "delivery_number") $select["where"]["param_pedido.NUMENTREGA"] = $args["value"];
            // if ($args["filter"] === "pedido_number") $select["where"]["param_pedido.NUMERO_PEDIDO"] = $args["value"];
            // if ($args["filter"] === "barcode") $select["where"]["param_pedido.CODIGO_BARRAS"] = $args["value"];

            $select_entregas["order_by"] = "`pedido`.`DATAENTREGA` ASC";
            // $select_entregas["where"]["param_`pedido`.`SEPARADO`"] = 0;
            // $select_entregas["where"]["param_`pedido`.`CARREGADO`"] = 0;
            // $select_entregas["where"]["param_`pedido`.`EXPEDIDO`"] = 0;
            // $select_entregas["where"]["param_`pedido`.`FECHADO`"] = 0;
            // $select_entregas["where"]["param_`pedido`.`SEPARADO`"] = 0;

            $select_entregas = (object) $db->select($select_entregas, true);
            $return["select_entregas"] = $select_entregas;
            $entregas = [];
            foreach ($select_entregas->data as $row) :
                $entrega = (object)[];
                $entrega->code = $row->NUMENTREGA;
                $entrega->route = $row->ROTA;
                $entrega->delivery_date = date("d/m/Y", $row->DATAENTREGA);
                $entregas[] = $entrega;
            endforeach;

            $return["entregas"] = $entregas;

            return $response->withJson($return, 200);
        });

        $slim->get("/separation", function (Request $request, Response $response, $args) {
            $return["success"] = false;

            $select_pedidos["where"]["param_pedido.AUTORIZADO"] = 1;
            $select_pedidos["where"]["param_pedido.SEPARADO"] = 0;
            $select_pedidos["where"]["param_pedido.ORCAMENTO"] = 0;
            $select_pedidos["where"]["param_pedido.CANCELADO"] = 0;
            $select_pedidos["where"]["param_pedido.FECHADO"] = 0;

            $select_pedidos["where"]["raw"] = [
                "pedido.NUMENTREGA != ''"
            ];

            $select_pedidos = OrderController::list($select_pedidos);

            $return["orders"] = $select_pedidos;

            return $response->withJson($return, 200);
        });
    });

    include __DIR__ . "/../Routes/users.php";
    include __DIR__ . "/../Routes/expedition.php";
    // include __DIR__ . "/../Routes/separation.php";

    include __DIR__ . "/../Routes/products.php";
});

// Run application
$slim->run();
