<?php

use \Edgvi10\DBWalker as DB;
use \Edgvi10\Helpers;
use \Linkinfo\Functions;
use \Linkinfo\OrderController;
use \Slim\Http\Request as Request;
use \Slim\Http\Response as Response;

$slim->group("/expedition", function ($slim) {
    $slim->get("[/]", function (Request $request, Response $response, $args) {
        $return["success"] = false;

        global $mysql_access;
        $db = new DB($mysql_access);

        $select_entrega["table"] = "`baselink`.`tab_entrega` AS `entrega`";

        $select_entrega["columns"] = [
            "`entrega`.`NUMENTRGA` AS `id`",
            "`entrega`.`LOJA` AS `store_id`",
            "`entrega`.`DATAENTREGA` AS `date`",

            "`entrega`.`ROTA` AS `route`",

            "`transp`.`CODIGO` AS `transporter_id`",
            "`transp`.`TRANSPORTADORA` AS `transporter_name`",
            "`transp`.`TEL1` AS `transporter_phone`",
            "`transp`.`CONTATO` AS `transporter_contact`",

            "`motorista`.`CODIGO` AS `driver_id`",
            "`entrega`.`MOTORISTA` AS `driver_name`",
            "`entrega`.`VEICULO` AS `vehicle`",
            "`entrega`.`PLACA` AS `vehicle_plate`",

            "`entrega`.`HSSAIDA` AS `start_time`",
            "`entrega`.`KMSAIDA` AS `start_km`",

            "`entrega`.`HSRETORNO` AS `end_time`",
            "`entrega`.`KMRETORNO` AS `end_km`",

            "`entrega`.`CARREGADOR` AS `loader`",
            "`entrega`.DATAEMBARQUE AS `load_date`",
            "`entrega`.`HORAINIEMBARQUE` AS `load_start`",
            "`entrega`.`HORAFIMEMBARQUE` AS `load_end`",

            "`entrega`.`PEDIDO` AS `order`",
        ];

        $select_entrega["joins"][] = ["LEFT", "`baselink`.`tab_transportadora` AS `transp`", "`transp`.`CODIGO` = `entrega`.`TRANSPORTADORA`"];
        $select_entrega["joins"][] = ["LEFT", "`baselink`.`tab_motorista_transportadora` AS `motorista`", "`motorista`.`CODIGO` = `entrega`.`CODMOTORISTA`"];
        // $select_entrega["where"]["param_`entrega`.`NUMENTRGA`"] = $args["delivery_number"];

        $select_entrega["where"]["param_`entrega`.`CANCELADA`"] = 0;
        $select_entrega["where"]["param_`entrega`.`SITUACAO`"] = 0;

        if (isset($_GET["delivery_date_start"])) $select_entrega["where"]["upperequal_`entrega`.`DATAENTREGA`"] = date("Y-m-d", strtotime($_GET["delivery_date_start"] . " - 30 days"));
        if (isset($_GET["delivery_number"])) $select_entrega["where"]["param_`entrega`.`NUMENTRGA`"] = $_GET["delivery_number"];


        $select_entrega["order_by"][] = "`entrega`.`DATAENTREGA` ASC";

        $select_entrega = (object) $db->select($select_entrega, true);
        $return["debug"]["select_entrega"] = $select_entrega;
        /**/
        if (!$select_entrega->success) :
            $return["message"] = $select_entrega->message;
            $return["debug"]["select_entrega"] = $select_entrega;
        else :
            $delivery_info = [];
            foreach ($select_entrega->data as $delivery) :
                if (empty($delivery->date)) continue;
                $delivery->code = (int) $delivery->id;
                $delivery->store_code = (int) $delivery->store_id;

                // $delivery->date_text = empty($delivery->date) ? "--" : (Helpers::timemask($delivery->date));
                $delivery->date_text = ($delivery->date === date("Y-m-d")) ? "Hoje" : (strftime("%d, %b", strtotime($delivery->date)));
                $delivery->date = $delivery->date;

                $delivery->load["loader"] = $delivery->loader;
                $delivery->load["start"] = empty($delivery->load_start) ? "--" : Helpers::timemask("{$delivery->load_date} {$delivery->load_start}");
                $delivery->load["end"] = empty($delivery->load_end) ? "--" : Helpers::timemask("{$delivery->load_date} {$delivery->load_end}");
                unset($delivery->loader, $delivery->load_date, $delivery->load_start, $delivery->load_end);

                $delivery->transporter["name"] = trim($delivery->transporter_name) ?? null;
                $delivery->transporter["phone"] = ltrim(Helpers::extractInt($delivery->transporter_phone), 0);
                $delivery->transporter["contact"] = trim($delivery->transporter_contact);
                unset($delivery->transporter_name, $delivery->transporter_phone, $delivery->transporter_contact);

                if (!empty($delivery->vehicle)) :
                    $delivery->transporter["vehicle"]["name"] = $delivery->vehicle;
                    $delivery->transporter["vehicle"]["plate"] = $delivery->vehicle_plate;
                endif;
                unset($delivery->vehicle, $delivery->vehicle_plate);

                if (!empty($delivery->driver_name)) :
                    $delivery->transporter["driver"]["code"] = $delivery->driver_id;
                    $delivery->transporter["driver"]["name"] = !empty($delivery->driver_name) ? Helpers::getName($delivery->driver_name) : null;
                endif;
                unset($delivery->driver_id, $delivery->driver_name);

                $delivery->delivery["start"]["time"] = $delivery->start_time;
                $delivery->delivery["start"]["km"] = $delivery->start_km;
                $delivery->delivery["end"]["time"] = $delivery->end_time;
                $delivery->delivery["end"]["km"] = $delivery->end_km;

                unset($delivery->start_time, $delivery->start_km, $delivery->end_time, $delivery->end_km);

                $delivery->orders = explode(",", $delivery->order);
                $delivery->total_orders = 0;
                $delivery->total_loaded = 0;
                $orders = [];
                foreach ($delivery->orders as $order_number) :
                    if (!isset($_GET["delivery_number"])) :
                        $order_number = trim($order_number);

                        $select_order = [];
                        $select_order["table"] = "`orc_link`.`tab_pedido` AS `pedido`";
                        $select_order["columns"] = [
                            "pedido.NUMERO_PEDIDO",
                            "pedido.AUTORIZADO",

                            "pedido.SEPARADO",
                            "pedido.SEPARADO_TODOS",
                            "pedido.CONFERIDO",
                            "pedido.EXPEDIDO",
                            "pedido.AUTEXPEDIDO",
                            "pedido.FECHADO",
                            "pedido.CARREGADO",
                            "pedido.ENTREGA",
                        ];
                        $select_order["group_by"] = "`NUMERO_PEDIDO`";
                        $select_order["where"]["param_`pedido`.`NUMERO_PEDIDO`"] = $order_number;
                        $select_order["where"]["param_`pedido`.`CANCELADO`"] = 0;

                        if (isset($_GET["separation"])) $select_order["where"]["param_`pedido`.`SEPARADO_TODOS`"] = 0;

                        if (isset($_GET["dispatch"])) $select_order["where"]["param_`pedido`.`SEPARADO_TODOS`"] = 1;
                        if (isset($_GET["dispatch"])) $select_order["where"]["param_`pedido`.`EXPEDIDO`"] = 0;

                        if (isset($_GET["truckload"])) $select_order["where"]["param_`pedido`.`EXPEDIDO`"] = 1;
                        if (isset($_GET["truckload"])) $select_order["where"]["param_`pedido`.`FECHADO`"] = 1;

                        $select_order = (object) $db->select($select_order);
                        $return["debug"]["select_order"][] = $select_order;
                        foreach ($select_order->data as $row) :
                            $order = (object)[];
                            $order->number = $row->NUMERO_PEDIDO;

                            $orders[] = $order->number;
                        endforeach;
                    else :
                        $order_number = trim($order_number);

                        $select_order = [];
                        $select_order["table"] = "`orc_link`.`tab_pedido` AS `pedido`";
                        $select_order["columns"] = [
                            "pedido.NUMERO_PEDIDO",
                            "pedido.COD_LOJA",
                            "pedido.DATA",

                            "pedido.CODIGO_VENDEDOR",
                            "pedido.VENDEDOR",

                            "pedido.CODIGO_CLIENTE",
                            "pedido.CLIENTE",
                            "cliente.NOME AS CLIENTE_NOME",
                            "cliente.FANTASIA AS CLIENTE_FANTASIA",

                            "pedido.CODIGO_BARRAS",
                            "produto.GTIN",

                            "pedido.PRODUTO",
                            "pedido.QTD_ITEM",
                            "unidade.UNIDADE",
                            "pedido.UNIDADE_MEDIDA",

                            "produto.LOCAL",
                            "produto.POSICAO_ESTOQ_ITEM",

                            "pedido.AUTORIZADO",

                            "pedido.SEPARADO",
                            "pedido.SEPARADO_TODOS",
                            "pedido.CONFERIDO",
                            "pedido.EXPEDIDO",
                            "pedido.AUTEXPEDIDO",
                            "pedido.FECHADO",
                            "pedido.CARREGADO",
                            "pedido.ENTREGA",

                            "pedido.DATAEMBARQUE",
                            "pedido.HORAIEMBARQUE",
                            "pedido.HORAFEMBARQUE",

                            "pedido.INICIOEMBARQUE",
                            "pedido.FIMEMBARQUE",

                            "pedido.DATAENTREGA",
                        ];
                        $select_order["joins"][] = ["LEFT", "`baselink`.`produtos` AS `produto`", "`pedido`.`COD_LOJA` = `produto`.`CODIGO_LOJA` AND `pedido`.`CODIGO_BARRAS` = `produto`.`CODIGO_BARRAS`"];
                        $select_order["joins"][] = ["LEFT", "`baselink`.`tab_unidade` AS `unidade`", "`pedido`.`UNIDADE_MEDIDA` = `unidade`.`CODIGO_UNIDADE`"];
                        $select_order["joins"][] = ["LEFT", "`orc_link`.`clientes` AS `cliente`", "`pedido`.`CODIGO_CLIENTE` = `cliente`.`CODIGO_CLIENTE`"];
                        $select_order["where"]["param_`pedido`.`NUMERO_PEDIDO`"] = $order_number;
                        $select_order["where"]["param_`pedido`.`CANCELADO`"] = 0;

                        if (isset($_GET["separation"])) $select_order["where"]["param_`pedido`.`SEPARADO_TODOS`"] = 0;

                        if (isset($_GET["dispatch"])) $select_order["where"]["param_`pedido`.`SEPARADO_TODOS`"] = 1;
                        if (isset($_GET["dispatch"])) $select_order["where"]["param_`pedido`.`EXPEDIDO`"] = 0;

                        if (isset($_GET["truckload"])) $select_order["where"]["param_`pedido`.`EXPEDIDO`"] = 1;
                        if (isset($_GET["truckload"])) $select_order["where"]["param_`pedido`.`FECHADO`"] = 1;
                        // if (isset($_GET["truckload"])) $select_order["where"]["not_`entrega`.`VEICULO`"] = "";

                        $select_order = (object) $db->select($select_order, true);
                        $return["select_order"] = $select_order;

                        $order = (object)[];
                        $products = [];

                        $current_order = null;
                        foreach ($select_order->data as $row) :
                            $order->number = $row->NUMERO_PEDIDO;

                            $order->seller_code = $row->CODIGO_VENDEDOR;
                            $order->seller_name = $row->VENDEDOR;

                            $order->customer_code = $row->CODIGO_CLIENTE;
                            $order->customer_name = $row->CLIENTE_NOME;
                            $order->customer_fancyname = $row->CLIENTE_FANTASIA;

                            $order_product = (object)[];
                            $order_product->barcode = $row->CODIGO_BARRAS;
                            $order_product->gtin = $row->GTIN;
                            $order_product->requested_amount = (float) ($row->QTD_ITEM);
                            $order_product->name = $row->PRODUTO;
                            $order_product->unit_name = $row->UNIDADE;

                            $order_product->location = $row->LOCAL;
                            $order_product->available = (float) $row->POSICAO_ESTOQ_ITEM;
                            if (!isset($order->products_reserved)) $order->products_reserved = 0;
                            if (!isset($order->products_dispatched)) $order->products_dispatched = 0;
                            if (!isset($order->products_loaded)) $order->products_loaded = 0;
                            if (!isset($order->products_delivered)) $order->products_delivered = 0;

                            if ((bool)$row->SEPARADO) $order->products_reserved = $order->products_reserved + 1;
                            if ((bool)$row->CONFERIDO) $order->products_dispatched = $order->products_dispatched + 1;
                            if ((bool)$row->CARREGADO) $order->products_loaded = $order->products_loaded + 1;
                            if ((bool)$row->ENTREGA) $order->products_delivered = $order->products_delivered + 1;

                            $order_product->reserved = (bool)$row->SEPARADO;
                            $order_product->dispatched = (bool)$row->CONFERIDO;
                            $order_product->loaded = (bool)$row->CARREGADO;
                            $order_product->delivered = (bool)$row->ENTREGA;

                            $order_products[$order_product->barcode] = $order_product;

                            $order->products[] = $order_product;
                            $current_order = $order->number;
                        endforeach;

                        foreach ($order_products as $product) :
                            $products[] = $products;
                        endforeach;

                        if (count($order->products)) :
                            if (count($order->products) === $order->products_loaded) :
                                $delivery->total_loaded = $delivery->total_loaded + 1;
                            endif;
                            $orders[] = $order;
                        endif;
                    endif;
                endforeach;

                $delivery->orders = $orders;
                $delivery->total_orders = count($delivery->orders);
                unset($delivery->order);

                $delivery_info[] = $delivery;
            endforeach;

            $return["deliveries"] = $delivery_info;
            $return["success"] = true;
        endif;
        /**/
        return $response->withJson($return, 200);
    });

    $slim->put("/separation/separate", function (Request $request, Response $response, $args) {
        $return["success"] = false;

        global $mysql_access;
        $db = new DB($mysql_access);

        $data = (object) $request->getParsedBody();

        $select_order = [];
        $select_order["table"] = "`orc_link`.`tab_pedido` AS pedido";
        $select_order["where"]["param_`pedido`.`NUMERO_PEDIDO`"] = $data->order_number;
        $select_order["where"]["param_`pedido`.`CODIGO_BARRAS`"] = $data->barcode;

        $select_order = (object) $db->select($select_order);

        if (!$select_order->success) :
            $return["message"] = $select_order->message;
            $return["debug"]["select_order"] = $select_order;
        else :
            $return["log"][] = "Produto encontrado";
            $update_order_item = [];
            $update_order_item["table"] = "`orc_link`.`tab_pedido` AS `pedido`";
            $update_order_item["where"]["param_`pedido`.`NUMERO_PEDIDO`"] = $data->order_number;
            $update_order_item["where"]["param_`pedido`.`CODIGO_BARRAS`"] = $data->barcode;
            $update_order_item["data"]["SEPARADO"] = 1;

            $update_order_item = (object) $db->update($update_order_item, true);

            $return["debug"]["update_order_item"] = $update_order_item;
            $return["success"] = $update_order_item->success;
            $return["affected_rows"] = $update_order_item->affected_rows;
        endif;

        return $response->withJson($return, 200);
    });

    $slim->put("/separation/finish", function (Request $request, Response $response, $args) {
        $return["success"] = false;

        global $mysql_access;
        $db = new DB($mysql_access);

        $data = (object) $request->getParsedBody();

        $select_order = [];
        $select_order["table"] = "`orc_link`.`tab_pedido` AS pedido";
        $select_order["where"]["param_`pedido`.`NUMERO_PEDIDO`"] = $data->order_number;

        $select_order = (object) $db->select($select_order);

        if (!$select_order->success) :
            $return["message"] = $select_order->message;
            $return["debug"]["select_order"] = $select_order;
        else :
            $return["log"][] = "Produto encontrado";
            $update_order_item = [];
            $update_order_item["table"] = "`orc_link`.`tab_pedido` AS `pedido`";
            $update_order_item["where"]["param_`pedido`.`NUMERO_PEDIDO`"] = $data->order_number;
            $update_order_item["data"]["SEPARADO_TODOS"] = 1;

            $update_order_item = (object) $db->update($update_order_item, true);

            $return["debug"]["update_order_item"] = $update_order_item;
            $return["success"] = $update_order_item->success;
            $return["affected_rows"] = $update_order_item->affected_rows;
        endif;

        return $response->withJson($return, 200);
    });

    $slim->put("/dispatch/check", function (Request $request, Response $response, $args) {
        $return["success"] = false;

        global $mysql_access;
        $db = new DB($mysql_access);

        $data = (object) $request->getParsedBody();

        $select_order = [];
        $select_order["table"] = "`orc_link`.`tab_pedido` AS pedido";
        $select_order["where"]["param_`pedido`.`NUMERO_PEDIDO`"] = $data->order_number;
        $select_order["where"]["param_`pedido`.`CODIGO_BARRAS`"] = $data->barcode;

        $select_order = (object) $db->select($select_order);

        if (!$select_order->success) :
            $return["message"] = $select_order->message;
            $return["debug"]["select_order"] = $select_order;
        else :
            $return["log"][] = "Produto encontrado";
            $update_order_item = [];
            $update_order_item["table"] = "`orc_link`.`tab_pedido` AS `pedido`";
            $update_order_item["where"]["param_`pedido`.`NUMERO_PEDIDO`"] = $data->order_number;
            $update_order_item["where"]["param_`pedido`.`CODIGO_BARRAS`"] = $data->barcode;
            $update_order_item["data"]["CONFERIDO"] = 1;

            $update_order_item = (object) $db->update($update_order_item, true);

            $return["debug"]["update_order_item"] = $update_order_item;
            $return["success"] = $update_order_item->success;
            $return["affected_rows"] = $update_order_item->affected_rows;
        endif;

        return $response->withJson($return, 200);
    });

    $slim->put("/dispatch/finish", function (Request $request, Response $response, $args) {
        $return["success"] = false;

        global $mysql_access;
        $db = new DB($mysql_access);

        $data = (object) $request->getParsedBody();

        $select_order = [];
        $select_order["table"] = "`orc_link`.`tab_pedido` AS pedido";
        $select_order["where"]["param_`pedido`.`NUMERO_PEDIDO`"] = $data->order_number;

        $select_order = (object) $db->select($select_order);

        if (!$select_order->success) :
            $return["message"] = $select_order->message;
            $return["debug"]["select_order"] = $select_order;
        else :
            $return["log"][] = "Produto encontrado";
            $update_order_item = [];
            $update_order_item["table"] = "`orc_link`.`tab_pedido` AS `pedido`";
            $update_order_item["where"]["param_`pedido`.`NUMERO_PEDIDO`"] = $data->order_number;
            $update_order_item["data"]["EXPEDIDO"] = 1;
            $update_order_item["data"]["AUTEXPEDIDO"] = $data->user_name;

            $update_order_item = (object) $db->update($update_order_item, true);

            $return["debug"]["update_order_item"] = $update_order_item;
            $return["success"] = $update_order_item->success;
            $return["affected_rows"] = $update_order_item->affected_rows;
        endif;

        return $response->withJson($return, 200);
    });

    $slim->put("/truckload/start", function (Request $request, Response $response, $args) {
        $return["success"] = false;

        global $mysql_access;
        $db = new DB($mysql_access);

        $data = (object) $request->getParsedBody();

        $update_entrega = [];
        $update_entrega["table"] = "`baselink`.`tab_entrega` AS `entrega`";
        $update_entrega["data"]["DATAEMBARQUE"] = date("Y-m-d");
        $update_entrega["data"]["HORAINIEMBARQUE"] = date("H:i:s");
        $update_entrega["data"]["CARREGADOR"] = $data->loader_name;
        $update_entrega["where"]["param_`entrega`.`NUMENTRGA`"] = $data->delivery_number;

        $update_entrega = (object) $db->update($update_entrega, true);
        $return["debug"]["update_entrega"] = $update_entrega;
        $return["success"] = $update_entrega->success;
        $return["load_start"] = Helpers::timemask(date("Y-m-d H:i:s"));

        return $response->withJson($return, 200);
    });

    $slim->put("/truckload/finish", function (Request $request, Response $response, $args) {
        $return["success"] = false;

        global $mysql_access;
        $db = new DB($mysql_access);

        $data = (object) $request->getParsedBody();

        $update_entrega = [];
        $update_entrega["table"] = "`baselink`.`tab_entrega` AS `entrega`";
        // $update_entrega["data"]["DATAEMBARQUE"] = date("Y-m-d");
        $update_entrega["data"]["HORAFIMEMBARQUE"] = date("H:i:s");
        $update_entrega["data"]["CARREGADOR"] = $data->user_name;
        $update_entrega["where"]["param_`entrega`.`NUMENTRGA`"] = $data->delivery_number;

        $update_entrega = (object) $db->update($update_entrega, true);
        $return["debug"]["update_entrega"] = $update_entrega;
        $return["success"] = $update_entrega->success;
        $return["load_end"] = Helpers::timemask(date("Y-m-d H:i:s"));

        return $response->withJson($return, 200);
    });

    $slim->put("/truckload/loaditem", function (Request $request, Response $response, $args) {
        $return["success"] = false;

        global $mysql_access;
        $db = new DB($mysql_access);

        $data = (object) $request->getParsedBody();

        $select_order = [];
        $select_order["table"] = "`orc_link`.`tab_pedido` AS pedido";
        $select_order["where"]["param_`pedido`.`NUMERO_PEDIDO`"] = $data->order_number;
        $select_order["where"]["param_`pedido`.`CODIGO_BARRAS`"] = $data->barcode;

        $select_order = (object) $db->select($select_order);

        $return["log"][] = $data;

        if (!$select_order->success) :
            $return["message"] = $select_order->message;
            $return["debug"]["select_order"] = $select_order;
        else :
            $return["log"][] = "Produto encontrado";
            if ($data->loaded_unit == 1 || $data->loaded_unit === $data->requested_amount) :
                $update_order_item = [];
                $update_order_item["table"] = "`orc_link`.`tab_pedido` AS `pedido`";
                $update_order_item["where"]["param_`pedido`.`NUMERO_PEDIDO`"] = $data->order_number;
                $update_order_item["where"]["param_`pedido`.`CODIGO_BARRAS`"] = $data->barcode;

                if ($data->loaded_unit == 1) :
                    $update_order_item["data"]["DATAEMBARQUE"] = date("Y-m-d");
                    $update_order_item["data"]["INICIOEMBARQUE"] = date("Y-m-d");
                    $update_order_item["data"]["HORAIEMBARQUE"] = date("H:i:s");
                    $return["log"][] = "Inicio do embarque";
                endif;

                if ($data->loaded_unit === $data->requested_amount) :
                    $update_order_item["data"]["CARREGADO"] = 1;
                    $update_order_item["data"]["FIMEMBARQUE"] = date("Y-m-d");
                    $update_order_item["data"]["HORAFEMBARQUE"] = date("H:i:s");
                    $return["log"][] = "Fim do embarque";
                endif;

                $update_order_item = (object) $db->update($update_order_item, true);

                // $return["debug"]["update_order_item"] = $update_order_item;
                $return["success"] = $update_order_item->success;
                $return["affected_rows"] = $update_order_item->affected_rows;
            else :
                $return["success"] = true;
            endif;
        endif;

        return $response->withJson($return, 200);
    });
});
