<?php

use \Edgvi10\DBWalker as DB;
use Edgvi10\Helpers;
use Linkinfo\Functions;
use \Slim\Http\Request as Request;
use \Slim\Http\Response as Response;

$slim->group("/login", function ($slim) {
    $slim->post("", function (Request $request, Response $response, $args) {
        global $mysql_access;
        global $debug;
        $log = [];

        $return["success"] = false;
        $db = new DB($mysql_access);

        $data = (object) $request->getParsedBody();

        $ua = $_SERVER['HTTP_USER_AGENT'];
        $ip = $_SERVER['REMOTE_ADDR'];
        $data->device = $ua;
        $data->ip = $ip;

        $login_success = false;

        $login = (object) $db->select([
            "table" => "`baselink`.`operadores` AS user",
            "columns" => [
                "user.COD_LOJA AS store_code",
                "user.CODIGO AS cod",
                "user.FUNCAO AS role",
                "user.NOME_OPERADOR AS name",
                "user.NOME AS username",
                "user.SENHA AS password",
                "user.DATA_CAD AS created_at",
            ],
            "group_by" => "`CODIGO`",
            "where" => [
                "param_COD_LOJA" => ($data->store_code),
                "param_NOME" => Functions::encrypt(mb_strtoupper($data->username)),
                "param_SENHA" => Functions::encrypt($data->password),
            ]
        ], true);

        // exit(json_encode($login));
        if ($debug) $log["login"] = $login;

        if ($login->results) :
            $users = [];
            foreach ($login->data as $user) :
                $user->name = Helpers::getName($user->name);
                $user->username = strtolower(Functions::encrypt($user->username));
                $user->created_at = str_replace("/", "-", $user->created_at);

                $user->verify_code = Helpers::base64url_encode(Functions::encrypt($user->password) . $user->username);
                unset($user->password);

                $user->token = Helpers::base64url_encode($user->store_code . "|" . $user->cod . "|" . $user->username . "|" . date("YmdHis"));

                $users[] = $user;
            endforeach;

            $return["user"] = (count($users) > 1) ? $users : $users[0];
            $return["success"] = $login->success;
        endif;

        // if ($debug) $return["log"] = $log;
        // if ($debug) $return["debug"]["body"] = $data;

        return $response->withJson($return, 200);
    });

    $slim->delete("/{token}", function (Request $request, Response $response, $args) {
        $return["success"] = true;
        return $response->withJson($return, 200);
    });
});
