<?php

use \Edgvi10\DBWalker as DB;
use Edgvi10\Helpers;
use Linkinfo\Functions;
use \Slim\Http\Request as Request;
use \Slim\Http\Response as Response;

$slim->group("/products", function ($slim) {
    $slim->get("[/search]", function (Request $request, Response $response, $args) {
        $return["success"] = true;

        $get = (object) $_GET;

        global $mysql_access;
        exit(json_encode($mysql_access));
        $db = new DB($mysql_access);

        $select_products = [
            "table" => "`baselink`.`produtos` AS prod",
            "columns" => [
                "prod.CODIGO_BARRAS AS barcode",
                "prod.DESCRICAO AS name",
                "prod.POSICAO_ESTOQ_ITEM AS available",
                // "prod.CODIGO_CATEGORIA AS cat_id",
            ],
            "where" => [
                "param_`prod`.`insumo`" => 0,
                "param_`prod`.`inativo`" => 0,
                "param_`prod`.`excluir`" => 0,
                "param_`prod`.`PRODUTO`" => 1,
            ]
        ];

        if (isset($get->q) && !empty($get->q)) :
            $query = explode(" ", $get->q);
            $terms = [];
            foreach ($query as $term) :
                $terms[] = "`prod`.`DESCRICAO` LIKE '%{$term}%'";
            endforeach;
            $terms = implode(" AND ", $terms);
            $select_products["where"]["raw"][] = "({$terms})";
        endif;

        // $select_products = (object) $db->build_select($select_products, true);r
        $return["select_products"] = $select_products;

        $products = [];
        // foreach ($select_products->data as $product) :


        //     $products[] = $product;
        // endforeach;

        $return["total"] = count($products);
        // $return["products"] = $products;

        return $response->withJson($return, 200);
    });

    $slim->get("/print/{delivery_number}", function (Request $request, Response $response, $args) {
        $return["success"] = true;

        global $mysql_access;
        $db = new DB($mysql_access);
        $generatorPNG = new Picqer\Barcode\BarcodeGeneratorPNG();

        $select_products = [
            "table" => "`baselink`.`produtos` AS prod",
            "columns" => [
                "prod.CODIGO_BARRAS AS barcode",
                "prod.DESCRICAO AS name",
                "prod.POSICAO_ESTOQ_ITEM AS available",
                // "prod.CODIGO_CATEGORIA AS cat_id",
            ],
            "joins" => [
                ["RIGHT", "`orc_link`.`tab_pedido` AS `pedido`", "`pedido`.`CODIGO_BARRAS` = `prod`.`CODIGO_BARRAS`"],
            ],
            "where" => [
                "param_`prod`.`insumo`" => 0,
                "param_`prod`.`inativo`" => 0,
                "param_`prod`.`excluir`" => 0,
                "param_`prod`.`PRODUTO`" => 1,
            ],
            "group_by" => "`pedido`.`CODIGO_BARRAS`",
        ];

        $select["where"]["param_order.NUMENTREGA"] = $args["delivery_number"];

        $select_products = (object) $db->select($select_products, true);
        // $return["select_products"] = $select_products;

?>
        <!DOCTYPE html>
        <html lang="en">

        <head>
            <meta charset="UTF-8">
            <meta http-equiv="X-UA-Compatible" content="IE=edge">
            <meta name="viewport" content="width=device-width, initial-scale=1.0">
            <title>Document</title>

            <style>
                body {
                    background: #fff;
                    color: #212121;
                    font-family: "Roboto", "Arial", sans-serif;
                    font-size: 10px;
                    line-height: 150%;
                }

                table {
                    margin: 0 auto;
                    max-width: 960px;
                    width: 100%;
                }

                th,
                td {
                    text-transform: uppercase;
                    text-align: left;
                    line-height: 150%;
                    padding: 4px;
                    vertical-align: middle;
                }

                small {
                    display: block;
                }

                td>img {
                    display: block;
                    width: 200px;
                    height: 30px;
                }
            </style>
        </head>

        <body>
            <table>
                <thead>
                    <tr>
                        <th>Produto</th>
                        <th>Código de Barras</th>
                    </tr>
                </thead>
                <tbody>
                    <?php
                    $products = [];
                    foreach ($select_products->data as $product) :
                        $product->barcode_image = base64_encode($generatorPNG->getBarcode($product->barcode, $generatorPNG::TYPE_CODE_128, 3, 30));
                    ?>
                        <tr>
                            <td>
                                <b><?= "{$product->name}" ?></b>
                                <small><?= "{$product->barcode}" ?></small>
                            </td>
                            <td><img src="data:image/png;base64,<?= "{$product->barcode_image}" ?>" /></td>
                        </tr>
                    <?php
                        $products[] = $product;
                    endforeach;
                    ?>
                </tbody>
            </table>
        </body>

        </html>
<?php
        $return["total"] = count($products);
        $return["products"] = $products;

        // return $response->withJson($return, 200);
    });

    $slim->post("", function (Request $request, Response $response, $args) {
        $return["success"] = true;

        $data = (object) $request->getParsedBody();

        global $mysql_access;
        $db = new DB($mysql_access);

        $insert_products["table"] = "`baselink`.`produtos`";
        if (!empty($data)) :
            $product["CODIGO_INTERNO"] = date("ymdHis");
            $product["CODIGO_BARRAS"] = $data->barcode;
            $product["DESCRICAO"] = $data->name;

            $product["VALOR_VENDA"] = $data->unit_price;
            $product["PRODUTO"] = 1;

            $select_brands = (object) $db->select([
                "table" => "`tab_marcas`",
                "columns" => ["`CODIGO` AS `brand_id`", "`DESCRICAO` AS `brand_name`"],
                "where" => ["param_DESCRICAO" => $data->brand],
            ]);

            if (count($select_brands->data) > 0) :
                $product["CODIGO_MARCA"] = $select_brands->data[0]->brand_id;
            else :
                $select_brands = (object) $db->select([
                    "table" => "`tab_marcas`",
                    "columns" => ["`CODIGO` AS `brand_id`"],
                    "order_by" => "`CODIGO` DESC",
                    "limit" => 1,
                ], true);

                $brand_id = str_pad((int) $select_brands->data[0]->brand_id + 1, 4, "0", STR_PAD_LEFT);
                $brand_name = mb_strtoupper($data->brand);

                $insert_brand["table"] = "`tab_marcas`";
                $insert_brand["data"]["CODIGO"] = (string) "{$brand_id}";
                $insert_brand["data"]["DESCRICAO"] = $brand_name;

                $insert_brand = $db->insert($insert_brand, true);
                $return["insert_brands"] = $insert_brand;
                $product["CODIGO_MARCA"] = $brand_id;
            endif;

            $select_units = (object) $db->select([
                "table" => "`tab_unidade`",
                "columns" => ["`CODIGO` AS `unit_id`", "`DESCRICAO` AS `unit_name`", "`UNIDADE` AS `unit`"],
                "where" => [
                    "raw" => ["(`DESCRICAO` LIKE '%{$data->unit}%' OR `UNIDADE` = '{$data->unit}')"],
                ],
            ]);

            if (count($select_units->data) > 0) :
                $product["UNIDADE"] = $select_units->data[0]->unit_id;
            endif;

            $insert_products["data"][] = $product;
        endif;

        $return["insert_product"] = $insert_products;

        return $response->withJson($return, 200);
    });
});
