<?php

use \Linkinfo\Functions;

use \EDGVI10\Helpers;
use \EDGVI10\DBWalker as DB;

use \Slim\Http\Request as Request;
use \Slim\Http\Response as Response;

function selectOrderProducts($select)
{
    $return["success"] = false;

    global $mysql_access;
    $db = new DB($mysql_access);

    $select["table"] = "`baselink`.`produtos` AS `prod`";
    $select["columns"] = [
        "`prod`.`CODIGO_BARRAS` AS `barcode`",
        "`prod`.`DESCRICAO` AS `name`",

        "`prod`.`POSICAO_ESTOQ_ITEM` AS `available`",
        "`prod`.`QTD_MIN` AS `available_min`",

        "`prod`.`LOCAL` AS `location`",
        "`unit`.`UNIDADE` AS `unit`",
    ];
    $select["joins"][] = ["RIGHT", "`orc_link`.`tab_pedido` AS `order`", "`prod`.`CODIGO_BARRAS` = `order`.`CODIGO_BARRAS` AND `prod`.`CODIGO_LOJA` = `order`.`COD_LOJA`"];
    $select["joins"][] = ["LEFT", "`baselink`.`tab_unidade` AS `unit`", "`order`.`UNIDADE_MEDIDA` = `unit`.`CODIGO`"];

    // $select["limit"] = 200;

    $select_products = (object) $db->select($select, true);

    $return["select"] = $select;

    if (!$select_products->success) :
        $return["debug"] = ($select_products);
    else :
        $products = [];
        // $return["sql"] = ($select_products->query);
        foreach ($select_products->data as $product) :
            $order_rows = explode(",", $product->order_rows);
            $customer_rows = explode(",", $product->customer_rows);
            $route_rows = explode(",", $product->route_rows);
            $amount_rows = explode(",", $product->amount_rows);
            $delivery_codes = explode(",", $product->delivery_codes);
            $delivery_dates = explode(",", $product->delivery_dates);

            $select_similares = (object) $db->select([
                "table" => "`baselink`.`tab_similares`",
                "columns" => [
                    "CODIGO_SIMILAR as barcode",
                    "QUANTIDADE as amount"
                ],
                "where" => [
                    "param_CODIGO_BARRAS" => $product->barcode,
                ]
            ], true);

            $product->similares[] = ["barcode" => $product->barcode, "amount" => (int) "1"];
            foreach ($select_similares->data as $similar) :
                $product->similares[] = ["barcode" => $similar->barcode, "amount" => (int) $similar->amount];
            endforeach;

            $product->available = (float) $product->available - $product->separated;
            $product->available_min = (float) $product->available_min;
            $product->ordered = (float) $product->ordered;
            $product->location = (!empty($product->location)) ? $product->location : null;
            // $product->unit = $product->unit;

            $orders = [];
            for ($i = 0; $i < count($order_rows); $i++) :
                $order_number = $order_rows[$i];
                $customer_name = $customer_rows[$i];
                $amount = (float) $amount_rows[$i];

                $route_name = !empty($route_rows[$i]) ? $route_rows[$i] : null;
                $delivery_code = (int) $delivery_codes[$i];
                $delivery_date = !empty($delivery_dates[$i]) ? $delivery_dates[$i] : null;

                $orders[$order_number] = [
                    "number" => $order_number,
                    "customer_name" => $customer_name,
                    "route_name" => $route_name,
                    "amount" => $amount,
                    "delivery_code" => $delivery_code,
                    "delivery_date" => $delivery_date,
                ];
            endfor;

            unset($product->order_rows);
            unset($product->customer_rows);
            unset($product->route_rows);
            unset($product->amount_rows);
            unset($product->delivery_codes);
            unset($product->delivery_dates);

            $product->orders = $orders;

            $products[$product->barcode] = $product;
        endforeach;
        $return["products"] = $products;
        $return["success"] = true;
    endif;
    return $return;
}

$slim->group("/separation", function ($slim) {
    $slim->get("/{filter}/{value}/products", function (Request $request, Response $response, $args) {
        $select["where"]["param_order.AUTORIZADO"] = 1;
        $select["where"]["param_order.SEPARADO"] = 0;
        $select["where"]["param_order.ORCAMENTO"] = 0;
        $select["where"]["param_order.CANCELADO"] = 0;
        $select["where"]["param_order.FECHADO"] = 0;
        $select["where"]["raw"][] = "(`order`.`FV` = 1 AND `order`.`AUTORIZACAOFV` = 1 OR `order`.`FV` = 0)";

        if ($args["filter"] === "delivery_number") $select["where"]["param_order.NUMENTREGA"] = $args["value"];
        if ($args["filter"] === "order_number") $select["where"]["param_order.NUMERO_PEDIDO"] = $args["value"];
        if ($args["filter"] === "barcode") $select["where"]["param_order.CODIGO_BARRAS"] = $args["value"];

        $select["group_by"] = "`order`.`CODIGO_BARRAS`";
        $select["order_by"] = "`prod`.`LOCAL`, `order`.`DATAENTREGA` ASC";

        // exit(json_encode($select));

        $return = selectOrderProducts($select);

        return $response->withJson($return, 200);
    });

    $slim->put("/{filter}/{value}/separate/{barcode}/{order_number}", function (Request $request, Response $response, $args) {
        global $mysql_access;
        $db = new DB($mysql_access);

        $return["success"] = false;

        $body = (object) $request->getParsedBody();
        $barcode = $args["barcode"];
        $orders = $args["order_number"];

        $orders = explode("|", $orders);

        foreach ($orders as $order_number) :
            $separate = [];
            $separate["table"] = "`orc_link`.`tab_pedido`";

            $separate["where"]["param_CODIGO_BARRAS"] = $barcode;
            $separate["where"]["param_NUMERO_PEDIDO"] = $order_number;
            $select_reserved = $separate;

            $separate["data"]["SEPARADO"] = (!isset($_GET["undo"])) ? 1 : 0;

            $separate = (object) $db->update($separate, true);

            unset($select_reserved["where"]["param_CODIGO_BARRAS"]);
            $select_reserved["where"]["param_SEPARADO"] = 0;

            $select_reserved = (object) $db->select($select_reserved, true);
            // $return["reserved"] = $select_reserved->found;
            if ($select_reserved->found === 0) :
                $separate_all = (object) $db->update([
                    "table" => "`orc_link`.`tab_pedido`",
                    "where" => [
                        "param_NUMERO_PEDIDO" => $order_number
                    ],
                    "data" => [
                        "SEPARADO_TODOS" => 1,
                    ]
                ], true);
            endif;

            if (!$separate->success) :
                $return["fail"][] = $separate;
            else :
                $select["where"]["param_order.AUTORIZADO"] = 1;
                $select["where"]["param_order.SEPARADO"] = 0;
                $select["where"]["param_order.ORCAMENTO"] = 0;
                $select["where"]["param_order.CANCELADO"] = 0;
                $select["where"]["param_order.FECHADO"] = 0;
                $select["where"]["raw"][] = "(`order`.`FV` = 1 AND `order`.`AUTORIZACAOFV` = 1 OR `order`.`FV` = 0)";

                if ($args["filter"] === "delivery_number") $select["where"]["param_order.NUMENTREGA"] = $args["value"];
                if ($args["filter"] === "order_number") $select["where"]["param_order.NUMERO_PEDIDO"] = $args["value"];
                if ($args["filter"] === "barcode") $select["where"]["param_order.CODIGO_BARRAS"] = $args["value"];

                $select["group_by"] = "`order`.`CODIGO_BARRAS`";
                $select["order_by"] = "`prod`.`LOCAL`, `order`.`DATAENTREGA` ASC";

                $return = selectOrderProducts($select);
            endif;
        endforeach;

        return $response->withJson($return, 200);
    });
});
