<?php

use \Linkinfo\Functions;

use \EDGVI10\Helpers;
use \EDGVI10\DBWalker as DB;

use \Slim\Http\Request as Request;
use \Slim\Http\Response as Response;

$slim->group("/users", function ($slim) {
    $slim->get("", function (Request $request, Response $response, $args) {
        $return["success"] = false;

        return $response->withJson($return, 200);
    });

    $slim->get("/menu", function (Request $request, Response $response, $args) {
        $return["success"] = false;

        $menu = [];

        $checkout = [];
        $checkout["title"] = "Caixa";
        $checkout["description"] = "Terminal de Venda, Catálogo de Produtos, Trocas e Relatórios.";
        $checkout["items"][] = ["icon" => "fad fa-cash-register", "label" => "Venda"];
        $checkout["items"][] = ["icon" => "fad fa-inventory", "label" => "Produtos"];
        $checkout["items"][] = ["icon" => "fad fa-exchange", "label" => "Troca"];
        $checkout["items"][] = ["icon" => "fad fa-chart-pie", "label" => "Relatório"];
        $checkout["items"][] = ["icon" => "fad fa-users", "label" => "Usuários"];

        $inventory = [];
        $inventory["title"] = "Estoque";
        $inventory["description"] = "Controle de estoque, entrada de produtos, inventário.";
        $inventory["items"][] = ["icon" => "fad fa-inventory", "label" => "Estoque"];
        $inventory["items"][] = ["icon" => "fad fa-truck-ramp", "label" => "Entrada de Produtos"];
        $inventory["items"][] = ["icon" => "fad fa-box-check", "label" => "Inventário"];

        $expedition = [];
        $expedition["title"] = "Expedição";
        $expedition["description"] = "Controle de estoque, separação, despacho e carregamento de mercadorias.";
        $expedition["items"][] = ["icon" => "fad fa-hand-holding-box", "label" => "Separação", "url" => "/expedition/separation"];
        $expedition["items"][] = ["icon" => "fad fa-pallet", "label" => "Conferêcia", "url" => "/expedition/dispatch"];
        $expedition["items"][] = ["icon" => "fad fa-truck-loading", "label" => "Carregamento", "url" => "/expedition/truck-loading"];
        $expedition["items"][] = ["icon" => "fad fa-tasks-alt", "label" => "Visão Geral"];

        $salesforce = [];
        $salesforce["title"] = "Força de Vendas";
        $salesforce["description"] = "Pedidos, catálogo, clientes e relatórios em tempo real.";
        $salesforce["items"][] = ["icon" => "fad fa-file-invoice", "label" => "Pedidos", "disabled" => true];
        $salesforce["items"][] = ["icon" => "fad fa-address-book", "label" => "Clientes", "disabled" => true];
        $salesforce["items"][] = ["icon" => "fad fa-map-marked-alt", "label" => "Visitas", "disabled" => true];
        $salesforce["items"][] = ["icon" => "fad fa-money-check", "label" => "Tabela de Preços", "disabled" => true];
        $salesforce["items"][] = ["icon" => "fad fa-chart-pie", "label" => "Relatórios", "disabled" => true];
        $salesforce["items"][] = ["icon" => "fad fa-list", "label" => "Catálogo", "disabled" => true];

        $delivery = [];
        $delivery["title"] = "Entrega";
        $delivery["description"] = "Rotas, pedidos, conferência de carga e relatórios.";
        $delivery["items"][] = ["icon" => "fad fa-map-marked-alt", "label" => "Rotas"];
        $delivery["items"][] = ["icon" => "fad fa-box-check", "label" => "Conferir Carga", "disabled" => true];
        $delivery["items"][] = ["icon" => "fad fa-file-invoice-dollar", "label" => "Relatórios", "disabled" => true];

        $adm = [];
        $adm["title"] = "Administração";
        $adm["description"] = "Relatórios, autorizações e monitoramento em tempo real.";
        $adm["items"][] = ["icon" => "fad fa-unlock-alt", "label" => "Autorizações", "disabled" => true];
        $adm["items"][] = ["icon" => "fad fa-user-chart", "label" => "Vendas", "disabled" => true];
        $adm["items"][] = ["icon" => "fad fa-file-invoice-dollar", "label" => "Financeiro", "disabled" => true];
        $adm["items"][] = ["icon" => "fad fa-chart-pie", "label" => "Centros de Custo", "disabled" => true];

        $menu[] = $checkout;
        $menu[] = $inventory;
        $menu[] = $expedition;
        $menu[] = $delivery;
        $menu[] = $salesforce;
        $menu[] = $adm;

        $return["menu"] = $menu;

        return $response->withJson($return, 200);
    });
});
