﻿# Mapa de Rotas

## WDMServer: Warehouse Dispatch Management Server

Mapa de rotas da API versão 1.0.0 que alimentará os aplicativos relacionados ao WMS da Link Informática.

---

Login de usuário: 
`POST: /login`

Logout de usuário: 
`DELETE: /login/{token}`

---

### Estoque

Rotas para leitura de estoque e demais informações referente ao cadastro de produtos.

Filtrar produtos: `GET: /{token}/products ? {search|barcode}`

Detalhes do produto: `GET: /{token}/products/{uuid|MD5|barcode}`

---
### Expedição

#### Separação

Listar produtos para Separação:
`GET: /{token}/expedition/separation/{filter:delivery_number|order_number}/{value}`

Separar Produto:
`PUT: /{token}/expedition/separation/{filter:delivery_number|order_number}/{value}/separate/{barcode}/{order_numbers}`

#### Conferência

Produtos para Conferência:
`GET: /{token}/expedition/dispatch/{filter:delivery_number|order_number}/{value}`

Conferir Produto:
`PUT: /{token}/expedition/dispatch/{filter:delivery_number|order_number}/{value}/check/{barcode}/{order_numbers}`

#### Carregamento

Produtos para Carregamento:
`GET: /{token}/expedition/truckload/{filter:delivery_number}/{value}`

Carregar Produto:
`PUT: /{token}/expedition/truckload/{filter:delivery_number}/{value}/load/{barcode}/{order_numbers}`

---

### Entrega

Rotas de uso da interface de Entrega.

Listar rotas de entrega: `GET: /{token}/routes[/{delivery_number}]`

Operações da Rota: `PUT: /{token}/routes/{delivery_number}/{start|stop|finish}`

Lista pedidos e ítens dos pedidos: `GET: /{token}/routes/{delivery_number}/orders[/{order_number}]`

Finalizar ou Retornar pedido: `PUT: /{token}/routes/{delivery_number}/orders/{order_number}/{finish|return}`

Atualizar item do pedido: `PUT: /{token}/routes/{delivery_number}/orders/{order_number}/check/{barcode}/{delivered|missing}`
